package com.rameses.gov.etracs.landtax.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.reports.*;

class RemittanceReportAbstractRPTDetailModel extends ReportController 
{
    @Binding
    def binding;

    @Service("LandTaxReportAbstractTaxCollectionService")
    def svc
    
    String title = "Abstract of RPT Collection (Detail)";
    String reportpath = "com/rameses/gov/etracs/landtax/report/abstractofcollectiondetail/"
    String reportName = reportpath + 'abstractrptcollectiondetail.jasper' 

    def periods = ['QUARTERLY', 'ANNUAL']
    def period
    
    def data = [:]

    def initReport() {
        period = periods[0]
        return preview();
    }

    void setPeriod(period) {
        this.period = period;
        preview();
        binding.refresh();
    }
    
    def getReportData(){
        entity.period = period;
        data =  svc.generateAbstractOfRPTCollectionDetail( entity );
        return data.items;
    }

    SubReport[] getSubReports() {
            return [ 
            new SubReport("Item", reportpath + "abstractrptcollectiondetailitem.jasper") 
        ] as SubReport[];    
    }
    
    
    Map getParameters(){
        return data.header 
    }
}      