package com.rameses.gov.etracs.landtax.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.reports.*;

class TopNRealProperytTaxpayerModel extends com.rameses.gov.etracs.rpt.report.AsyncReportController
{
    @Service('LandTaxReportTopNRealPropertyTaxpayerService') 
    def svc
    
    String title = 'Top N Realty Tax Payers';
    String reportName = 'com/rameses/gov/etracs/rpt/report/landtax/topn_realproperty_taxpayer.jasper';
    
    def task;
    def msg;
    
    def payeetypes = [
        [id: 'payee', caption: 'Payee' ],
        [id: 'owner', caption: 'Declared Owner' ],
        [id: 'propowner', caption: 'Property Owner' ],
    ];

    def entitytypes = [
        [id: 'INDIVIDUAL', caption: 'Individual' ],
        [id: 'JURIDICAL', caption: 'Juridical' ],
        [id: 'MULTIPLE', caption: 'Multiple' ],
    ];

    def rputypes = [
        [id: 'land', caption: 'Land' ],
        [id: 'bldg', caption: 'Building' ],
        [id: 'mach', caption: 'Machinery' ],
        [id: 'planttree', caption: 'Plant/Tree' ],
        [id: 'misc', caption: 'Miscellaneous' ],
    ];
    
    def initReport(){
        entity.topn = 10;
        entity.payeetype = payeetypes[0];
        return super.initReport();
    }
    
    
    void buildReportData(entity, asyncHandler){
        svc.buildReport(entity, asyncHandler);
    }
    
    def formControl = [
        getFormControls: {
            return [
                new FormControl( "integer", [caption:'Year', name:'entity.year', required:true]),
                new FormControl( "integer", [caption:'Top N', name:'entity.topn', required:true]), 
                new FormControl( "combo", [caption:'Payee Type', name:'entity.payeetype', expression:'#{item.caption}', items:'payeetypes', required: true, allowNull: false]),
                new FormControl( "combo", [caption:'Entity Type', name:'entity.entitytype', expression:'#{item.caption}', items:'entitytypes', emptyText:'All']),
                new FormControl( "combo", [caption:'Property Kind', name:'entity.rputype', expression:'#{item.caption}', items:'rputypes', emptyText:'All']),
            ]    
        } 
    ] as FormPanelModel;
}