package com.rameses.gov.etracs.landtax.report.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;

class BuildDelinquencyTask implements Runnable
{ 
    def threadPool;
    def svc;
    def entity;
    def barangays;
    def updateStatus = {};
    def onComplete = {};
    def tasks = [];
    def cancelled = false;
    def threadCount = 1;
    
    public void start(){
        new Thread(this).start();
    }
    
    public void cancel(){
        cancelled = true;
        tasks.each{
            it.cancel();
        }
        tasks.clear();
    }
    
    public void run(){
        for (int i = 0; i < barangays.size(); i++) {
            def item = barangays[i];
            def list = svc.getLedgersForProcess(item);
            while(list) {
                println 'BuildDelinquency [INFO] no. of ledgers: ' + list.size();
                while (!cancelled) {
                    if (list.size() == 0) break;
                    def ledger = list[0]
                    println 'BuildDelinquency [INFO] ledger: ' + ledger.objid;
                    ledger.builditem = item;
                    ledger.parentid = entity.objid;
                    ledger.billdate = entity.dtcomputed;

                    def retval = svc.buildDelinquency(ledger);
                    item.processed += retval.processed;
                    item.errors += retval.errors;
                    item.completed = (item.count == item.processed + item.errors + item.ignored)
                    list.remove(ledger);
                    updateStatus(item);
                    sleep(25);
                }
                if (cancelled) break;
                list = svc.getLedgersForProcess(item);
            }
            if (cancelled) break;
        }
        
        if (!cancelled){
            entity.putAll(svc.closeBuild([objid:entity.objid]));
        }
        
        onComplete();
    }

    private void sleep(ms){
        try{
            Thread.sleep(ms);
        }
        catch(e){
            //
        }
    }


}