package com.rameses.gov.etracs.landtax.report.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.reports.*;

class BuildRealtyTaxSummaryModel 
{
    @Binding
    def binding;
    
    @Service('LandTaxReportTopNRealPropertyTaxpayerService') 
    def svc;

    @Service('DateService')
    def dtSvc;
    
    String title = 'Build Realty Tax Collection Summary';
    
    
    def entity;
    def processing = false;
    def msg;
    def task;

    void init() {
        entity = [:]
        entity.year = dtSvc.getServerYear()
    }

    def oncomplete = {status ->
        processing = false;
        msg = null;
        task = null;
        
        if (status.error) {
            msg = status.msg
        }
        binding.refresh();
    }

    void buildSummary() {
        if (!MsgBox.confirm('Build summary for the specified year?')) return;

        processing = true;
        msg = 'Rebuild collection summary. Please wait...';

        task = new BuildCollectionSummaryTask([
            svc: svc,
            entity: entity,
            oncomplete: oncomplete
        ]);

        task.start();
    }

}

class BuildCollectionSummaryTask implements Runnable{
    def svc;
    def entity;
    def oncomplete;
    
    public void start() {
        new Thread(this).start();
    }
    
    public void run() {
        try {
            svc.buildSummary(entity);
            oncomplete([error: false]);
        } catch(err) {
            oncomplete([error: true, msg: err.message]);
        }
    }    
}