package com.rameses.gov.etracs.landtax.report.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.reports.*;


class NewlyAssessedPropertyListReportModel extends com.rameses.gov.etracs.rpt.report.AsyncReportController 
{
    @Service('LandTaxReportNewlyAssessedPropertyService') 
    def svc

    String title = 'List of Newly Assessed Properties';
    String reportPath = 'com/rameses/gov/etracs/landtax/reports/';
    
    
    def showPostingType = false;

    def reportformats = [
        [code: 'standard',  caption: 'Standard', reportname: 'newly_assessed_property_listing.jasper'],
    ]    
 
    
    def getPeriods() { 
        def periods = [
            [code:'yearly', name:'Yearly'], 
        ];
    }

    String getReportName() {
        return reportPath + entity.reportformat.reportname;
    }
    
    def initReport() { 
        def outcome = super.initReport();         
        entity.period = periods[0]; 
        def pdate = dtSvc.parseCurrentDate();
        entity.year = pdate.year;
        return outcome; 
    } 
    
    void buildReportData(entity, asyncHandler){
        svc.buildReportData(entity, asyncHandler);
    } 
} 