package com.rameses.gov.etracs.landtax.report.models;


import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.reports.*;
import com.rameses.etracs.shared.*;

class RealPropertyPaymentListReportModel extends com.rameses.gov.etracs.rpt.report.AsyncReportController 
{
    @Service('LandTaxReportRealPropertyPaymentService') 
    def svc

    String title = 'List of Real Property Payments';
    String reportPath = 'com/rameses/gov/etracs/landtax/reports/';
    
    
    def showPostingType = true;

    def postingtypes = [
        [code:'byliq', caption:'By Liquidation Date'],
        [code:'byrem', caption:'By Remittance Date'],
    ]
    
    def reportformats = [
        [code: 'standard',  caption: 'Standard', reportname: 'realproperty_payment_listing.jasper'],
    ]    
 
    
    def getPeriods() { 
        def periods = [
            [code:'yearly', name:'Yearly'], 
        ];
    }

    String getReportName() {
        return reportPath + entity.reportformat.reportname;
    }
    
    def initReport() { 
        def outcome = super.initReport();         
        entity.period = periods[0]; 
        def pdate = dtSvc.parseCurrentDate();
        entity.year = pdate.year;
        return outcome; 
    } 
    
    void buildReportData(entity, asyncHandler){
        svc.buildReportData(entity, asyncHandler);
    } 
} 