package com.rameses.gov.etracs.rptis.models;
        
import com.rameses.rcp.annotations.* 
import com.rameses.rcp.common.* 
import com.rameses.osiris2.client.*
import com.rameses.osiris2.common.*


public class MunicipalityRequestFAASSeriesMgmtModel
{
    @Service('MunicipalityRequestFAASSeriesService')
    def svc;

    String title = 'Request FAAS Series Management';
    

    void refresh() {
      barangayListHandler.load();
      seriesHandler.load();
    }

    def selectedBarangay;

    def barangayListHandler = [
      fetchList: { svc.getBarangays() }
    ]  as BasicListModel;



    def selectedSeries;

    def seriesHandler = [
      fetchList: {
        if (selectedBarangay) {
          return svc.getSeries(selectedBarangay);
        }
        return []; 
      }
    ]  as BasicListModel;


    def requestedSeriesHandler = [
      fetchList: { svc.getRequestedSeries(selectedSeries) }
    ] as BasicListModel


    def onsave = {
      seriesHandler.load();
    }

    def generateRequest() {
      return Inv.lookupOpener('faas:requestseries', [series: selectedSeries, onsave: onsave])
    }
}


