package com.rameses.gov.etracs.rptis.models;
        
import com.rameses.rcp.annotations.* 
import com.rameses.rcp.common.* 
import com.rameses.osiris2.client.*
import com.rameses.osiris2.common.*


public class MunicipalityRequestFAASSeriesModel
{
    @Service('MunicipalityRequestFAASSeriesService')
    def svc;

    String title = 'Request FAAS Series';

    def series; 
    def onsave = {};
    def entity = [requestedcount: 1, requestedby: [:]];


    def save() {
      if (MsgBox.confirm('Save requested series?')) {
        entity.series = series;
        svc.postRequestedSeries(entity);
        onsave();
        return '_close';
      }
    }

    def getSeriesRange() {
      if (entity.requestedcount == 1) {
        return series.nextseries;
      }
      def endseries = series.nextseries + entity.requestedcount - 1;
      return series.nextseries + ' - ' + endseries;
    }

    
}


