package com.rameses.wf.components;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.util.*;

class WfEventActionListModel extends ComponentBean {

    def selectedItem;
    def eventtype;
    boolean editable = true;
    def list;
    
    void init() {
        if(eventtype == "before") {
            list = value.beforeactions;
        }
        else {
            list = value.afteractions;
        }
    }
    
    def listHandler = [
        fetchList: { o->
            return list;
        },
        onOpenItem: { v,col->
            def sh = { o->
                v.putAll( o );
                v.eventtype = eventtype;
                listHandler.reload();
            }
            return Inv.lookupOpener( "sys_wf_eventaction:open", [savehandler: sh, entity: v ] );
        }
    ] as BasicListModel;
    
    def addItem() {
        def sh = { o->
            o.eventtype = eventtype;
            list << o;
            listHandler.reload();
        }
        return Inv.lookupOpener( "sys_wf_eventaction:create", [savehandler: sh] );
    }
    
    void removeItem() {
        if(!selectedItem) throw new Exception("Please select an item");
        if(!value._deletedactions)  value._deletedactions = [];
        value._deletedactions << selectedItem;
        list.remove(selectedItem);
    }

    void moveUp() {
        if(!selectedItem) return;
        int idx = list.indexOf( selectedItem );
        MsgBox.alert("selected item " + idx);
        if( idx == 0 ) return;
    }
    
    void moveDown() {
        if(!selectedItem) return;
    }
    
}
