package com.rameses.gov.treasury.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.enterprise.treasury.cashreceipt.BasicCashReceipt;

class MiscCashReceiptOrgMuniModel extends BasicCashReceipt {

    @Service('PersistenceService')
    def persistenceSvc;
    
    String entityName = "misc_org_muni";
    
    def muni;
    
    void init() {
        super.init(); 
        
        def env = ClientContext.getCurrentContext().getHeaders(); 
        
        def param = [_schemaname: 'sys_org'];
        param.findBy = [ objid: env.ORGID ]; 
        muni = persistenceSvc.read( param );
        
        if ( muni?.parent?.objid ) {
            param.findBy = [ objid: muni.parent.objid ]; 
            entity.province = persistenceSvc.read( param );
        }
    } 
    
    def getLookupBarangay() {
        def param = [query: [:]];
        param.query.filter = "sb.parent_objid = '"+ muni?.objid +"'"; 
        param.onselect = { o-> 
            if ( !o?.objid ) {
                entity.barangay = null; 
            }
            else {
                def mm = [_schemaname: 'sys_org'];
                mm.findBy = [ objid: o.objid ]; 

                entity.barangay = persistenceSvc.read( mm );
            }
        }
        param.onempty = {
            entity.barangay = null; 
        }
        
        def op = Inv.lookupOpener('barangay:lookup', param); 
        op.target = 'popup';
        return op; 
    }
}
