package com.rameses.gov.treasury.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.enterprise.treasury.cashreceipt.BasicCashReceipt;

class MiscCashReceiptOrgProvModel extends BasicCashReceipt {

    @Service('PersistenceService')
    def persistenceSvc;
    
    String entityName = "misc_org_prov";
    
    def prov;
    
    void init() {
        super.init(); 
        
        def env = ClientContext.getCurrentContext().getHeaders(); 
        
        def param = [_schemaname: 'sys_org'];
        param.findBy = [ objid: env.ORGID, orgclass: 'PROVINCE' ]; 
        prov = persistenceSvc.read( param );

        entity.province = prov; 
    } 
    
    def getLookupMunicipal() {
        def param = [:];
        param.onselect = { o-> 
            if ( !o?.objid ) {
                entity.municipality = null; 
            }
            else {
                def mm = [_schemaname: 'sys_org'];
                mm.findBy = [ objid: o.objid ]; 

                entity.municipality = persistenceSvc.read( mm );
            }
        }
        param.onempty = {
            entity.municipality = null; 
        }
        
        def op = Inv.lookupOpener('municipality:lookup', param); 
        op.target = 'popup';
        return op; 
    }
    
    def getLookupBarangay() {
        def param = [query: [:]];
        param.query.filter = "sb.parent_objid = '"+ entity.municipality?.objid +"'"; 
        param.onselect = { o-> 
            if ( !o?.objid ) {
                entity.barangay = null; 
            }
            else {
                def mm = [_schemaname: 'sys_org'];
                mm.findBy = [ objid: o.objid ]; 

                entity.barangay = persistenceSvc.read( mm );
            }
        }
        param.onempty = {
            entity.barangay = null; 
        }
        
        def op = Inv.lookupOpener('barangay:lookup', param); 
        op.target = 'popup';
        return op; 
    }
}
