package com.rameses.gov.treasury.report.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.reports.*;

class CashbookLiquidationReportModel extends AsyncReportController {

    @Service('CashbookLiquidationReportService') 
    def svc; 
    
    @Script('ReportPeriod') 
    def reportPeriod;
    
    String title = 'Cashbook Liquidation Report';
    String reportpath = 'com/rameses/gov/treasury/report/';

    def data;
    def tag;
    def periods; 
    def fundgroups;
    
    def templates = [ 
        [objid:'default', name:'Default', template: 'cashbook_liquidation.jasper'], 
        [objid:'template-b', name:'Template-B', template: 'cashbook_liquidation-template-b.jasper'] 
    ]; 
    
    void doInit( inv ) { 
        tag = inv?.properties?.tag; 
        init();
    } 

    boolean allow_multiple_fund_selection;
    
    def initReport() { 
        def outcome = super.initReport();
        
        def resp = svc.initReport([ tag: tag ]); 
        fundgroups = resp.fundgroups; 
        periods = reportPeriod.types.findAll{( it.type.matches('monthly|daily'))}
        entity.period = periods.find{( it.type == 'monthly' )}         
        entity.year = resp.year; 
        entity.account = resp.user; 
        
        if ( resp.allow_multiple_fund_selection ) {
            allow_multiple_fund_selection = resp.allow_multiple_fund_selection; 
        }
        return outcome; 
    }

    public String getReportName() {
        return reportpath + entity.template?.template; 
    }


    void buildReportData(entity, asyncHandler) {
        def m = reportPeriod.build( entity.period.type, entity ); 
        entity.startdate = m.startdate;
        entity.enddate = m.enddate; 
        
        svc.getReport( entity, asyncHandler );
    }
    
    void buildResult( o ) {
        data = o; 
    }
    
       
    Map getParameters() { 
        return data?.header; 
    } 

    boolean isDynamic() { 
        return true; 
    } 
    
    
    def lookupUser = Inv.lookupOpener('liquidatingofficer:lookup', [:]);  
    
    def _lookupFund;
    def getLookupFund() {
        if ( _lookupFund == null ) {
            def mm = [:]; 
            mm.multiSelect = allow_multiple_fund_selection; 
            _lookupFund = Inv.lookupOpener('report_fund:lookup', mm); 
        }
        return _lookupFund; 
    }
    
    def controls = [
        [type:"combo", caption:'Template', name:'entity.template', required:true, items:'templates', expression:'#{item.name}', preferredSize:'100,20', captionWidth:100, allowNull: false],
        [type:"combo", caption:'Period', name:'entity.period', required:true, items:'periods', expression:'#{item.title}', preferredSize:'100,20', captionWidth:100, allowNull: false],
        [type:"date", caption:'Date', name:'entity.date', required:true, preferredSize:'100,20', captionWidth:100, depends:'entity.period', visibleWhen:'#{entity.period?.type == "daily"}'],
        [type:"integer", caption:'Year', name:'entity.year', required:true, preferredSize:'100,20', captionWidth:100, depends:'entity.period', visibleWhen:'#{entity.period?.type == "monthly"}'],
        [type:"combo", caption:'Month', name:'entity.month', required:true, items:'reportPeriod.months', expression:'#{item.title}', preferredSize:'100,20', captionWidth:100, depends:'entity.period', visibleWhen:'#{entity.period?.type == "monthly"}'],

        [type:"lookup", caption:'Account', name:'entity.account', required:true, handlerObject: lookupUser, expression:'#{item.fullname}', preferredSize:'0,20', captionWidth:100],
        [type:"lookup", caption:'Fund', name:'entity.fund', handler:'lookupFund', expression:'#{item.title}', preferredSize:'0,20', captionWidth:100],
        [type:"combo", caption:'Fund Group', name:'entity.fundgroup', items:'fundgroups', expression:'#{item.objid}', preferredSize:'0,20', captionWidth:100]
    ]; 
    
    def formControl = [
        getControlList: {
            return controls;
        } 
    ] as FormPanelModel;    
}