package com.rameses.gov.treasury.report.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.reports.*;

class RemittanceRCDFormReportModel extends ReportController {

    @Binding
    def binding;
    
    def reportHandler;
    def options;
    
    String title = "Remittance RCD";
    
    def initReport() {
        options = [:];
        return preview();
    }
    
    String getReportName() {
        return reportHandler.getReportName(); 
    }
    
    SubReport[] getSubReports() { 
        return reportHandler.getSubReports(); 
    }
    
    Map getParameters() { 
        return reportHandler.getParameters();
    }
    
    def getReportData(){
        return reportHandler.getReportData( options ); 
    }

    def getCompressAFSerial() { 
        return options.compressAFSerial; 
    }
    void setCompressAFSerial( def value ) { 
        options.compressAFSerial = value.toString().matches('true|1');
        
        preview();
        binding.refresh() ;
    } 
    
    def getCompressAFNonSerial() { 
        return options.compressAFNonSerial; 
    }
    void setCompressAFNonSerial( def value ) { 
        options.compressAFNonSerial = value.toString().matches('true|1');
        
        preview();
        binding.refresh() ;
    }      
} 
