package com.rameses.gov.treasury.report.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.reports.*;

class ReportCollectionSummaryByFund extends AsyncReportController {

    @Service('TCReportService') 
    def svc;

    @Script('ReportPeriod')
    def reportPeriod;    

    String title = 'Report of Collection - By Fund';
    String reportpath = 'com/rameses/gov/treasury/report/collection/';
    String reportName = reportpath + 'collectionsummarybyfund.jasper';
    
    def _data;
    def funds = [];

    def postingtypes = [
        [objid: 'BY_LIQUIDATION_DATE', title:'By Liquidation Date'],
        [objid: 'BY_REMITTANCE_DATE',  title:'By Remittance Date']
    ]; 

    def initReport() {
        def outcome = super.initReport(); 

        def resp = svc.initReport([:]); 
        funds = resp.funds; 
        entity.year = resp.year; 
        entity.period = reportPeriod.types.find{ it.type == 'monthly' }
        return outcome; 
    } 

    void buildReportData(entity, asyncHandler) { 
        def m = reportPeriod.build( entity.period.type, entity ); 
        entity.startdate = m.startdate;
        entity.enddate = m.enddate; 
        svc.getCollectionByFund( entity, asyncHandler );
    }
    
    void buildResult( data ) { 
        this._data = data; 
        
        if ( !data.reportdata ) throw new Exception('No available record(s) that matches your criteria.');
    }  
    
    Map getParameters(){
        return _data?.header;
    }

    def formControl = [
        getControlList: {
           return [
                [ type:'combo', caption:'Period', name:'entity.period', required:true, items:'reportPeriod.types',  expression:'#{item.title}', preferredSize:'100,20', captionWidth:130],
                [ type:'integer', caption:'Year', name:'entity.year', required:true, depends:'entity.period', visibleWhen:'#{ entity.period.type.matches("yearly|quarterly|monthly")==true }', preferredSize:'100,20', captionWidth:130 ],
                [ type:'combo', caption:'Quarter', name:'entity.qtr', required:true, items:'reportPeriod.quarters', depends:'entity.period', visibleWhen:'#{ entity.period.type=="quarterly" }', preferredSize:'100,20', captionWidth:130],
                [ type:'combo', caption:'Month', name:'entity.month', required:true, items:'reportPeriod.months', expression:'#{item.title}', depends:'entity.period', visibleWhen:'#{ entity.period.type=="monthly" }', preferredSize:'100,20', captionWidth:130],
                [ type:'date', caption:'Date', name:'entity.date', required:true, depends:'entity.period', visibleWhen:'#{ entity.period.type=="daily" }', preferredSize:'100,20', captionWidth:130],
                [ type:'date', caption:'Start Date', name:'entity.startdate', required:true, depends:'entity.period', visibleWhen:'#{ entity.period.type=="range" }', preferredSize:'100,20', captionWidth:130],
                [ type:'date', caption:'End Date', name:'entity.enddate', required:true, depends:'entity.period', visibleWhen:'#{ entity.period.type=="range" }', preferredSize:'100,20', captionWidth:130],

                [ type:"combo", caption:'Posting Type', name:'entity.postingtype', required:true, items:'postingtypes', expression:'#{item.title}', allowNull:false, captionWidth:130 ],
                [ type:"combo", caption:'Fund', name:'entity.fund', items:'funds', expression:'#{item.desc}', captionWidth:130 ],
                [ type:"label", caption:'', preferredSize:'100,10'] 
           ]; 
        }
    ] as FormPanelModel;
}