package com.rameses.gov.etracs.rptis.report.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*
import com.rameses.osiris2.reports.*;
import com.rameses.etracs.shared.*;
import com.rameses.gov.etracs.rptis.util.*;

class AssessmentNoticeReportModel extends ReportController 
{
    @Binding
    def binding;

    @Service('RPTAssessmentNoticeService')
    def noticeSvc;

    @Service('ReportParameterService')
    def paramSvc;

    def entity;
    
    String title = 'Notice of Assessment Report';


    String reportpath = 'com/rameses/gov/etracs/rpt/report/notice/';
    String reportName = reportpath + 'notice.jasper';

    public boolean isDynamic() { return true; }

    def reporttypes = ['STANDARD', 'NATB'];
    def reportNames = [
        STANDARD: 'notice.jasper',
        NATB: 'natb.jasper'
    ]
    def reporttype = reporttypes[0];

    def preview(){
        report.viewReport();
        return 'preview';
    }

    String getReportName() {
        return reportpath + reportNames[reporttype];
    }

    void setReporttype(reporttype) {
        this.reporttype = reporttype
        preview();
        binding.refresh();
    }
    
    
    def getReportData(){
        def data = noticeSvc.getReportData([
            objid: entity.objid,
            reporttype: reporttype,
        ])
        data.items2 = data.items;
        saveSignatures(data);
        return data;
    }

    SubReport[] getSubReports() {
        return [ 
            new SubReport( 'NoticeItem', reportpath + 'noticeitem.jasper' ),
        ] as SubReport[];    
    }

    java.util.Map getParameters() { 
        def params = paramSvc.getStandardParameter()
        params.LOGOLGU = EtracsReportUtil.getInputStream("lgu-logo.png")
        params.BACKGROUND = EtracsReportUtil.getInputStream("background.png")
        params.LOGOASSESSOR = EtracsReportUtil.getInputStream("lgu-assessor.png")
        params.LOGOBLGF = EtracsReportUtil.getInputStream("lgu-blgf.png")
        return params
    }

    void saveSignatures(reportdata){
        reportdata.signatories.each{ k, v ->
            if (v.signature?.image){
                v.signaturebytes = (byte[])v.signature.image
            }
        }
    }   
}
