package com.rameses.gov.etracs.rptis.report.models;

import com.rameses.rcp.annotations.*
import com.rameses.rcp.common.*
import com.rameses.osiris2.client.*
import com.rameses.osiris2.reports.*;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.reports.*;


class BldgFieldInspectionReportModel extends com.rameses.gov.etracs.rpt.report.AsyncReportController
{
    @Service('RPTReportFieldInspectionDataService') 
    def svc 
    
    String title = 'Field Inspection Data for Building Report'
    
    def orderTypes = [
        [id: 'pin', title: 'PIN'],
        [id: 'name', title: 'Last Name'],
    ]

    def reporttypes = [
        [type: 'STANDARD', caption: "STANDARD", reportname: 'field_inspection_bldg.jasper'],
        [type: 'ALPHALIST', caption: "ALPHALIST", reportname: 'field_inspection_bldg_alphalist.jasper'],
    ]

    String getReportName() {
        def path = 'com/rameses/gov/etracs/rpt/report/';
        return path + entity.reporttype.reportname;
    } 
    
    void buildReportData(entity, asyncHandler){
        svc.getReportData(entity, asyncHandler);
    }
    
    def formControl = [
        getFormControls: {
            return [
                new FormControl( "combo", [caption:'LGU', name:'entity.lgu', allowNull: false, required:true, items:'lgus', expression:'#{item.name}']),
                new FormControl( "combo", [caption:'Barangay', name:'entity.barangay', required:true, items:'barangays', allowNull:false, expression:'#{item.name}', depends:'entity.lgu', dynamic:true]),
                new FormControl( "combo", [caption:'Format', name:'entity.reporttype', required:true, items:'reporttypes', allowNull:false, expression:'#{item.caption}']),
                new FormControl( "text", [caption:'Section', name:'entity.section', required:true, preferredSize:'50,19',  depends:'entity.reporttype', visibleWhen: "#{entity.reporttype.type == 'STANDARD' }"]),
                new FormControl( "text", [caption:'Parcel', name:'entity.parcel', preferredSize:'50,19',  depends:'entity.reporttype', visibleWhen: "#{entity.reporttype.type == 'STANDARD' }"]),
                new FormControl( "combo", [caption:'Order By', name:'entity.ordertype', required:true, items:'orderTypes', expression:'#{item.title}', allowNull:false,  preferredSize:'0,19', depends:'entity.reporttype', visibleWhen: "#{entity.reporttype.type == 'STANDARD' }"]),
            ]    
        },
    ] as FormPanelModel;
   
}