package com.rameses.gov.etracs.rptis.report.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.seti2.models.*;
import com.rameses.gov.etracs.rpt.workflow.RPTWorkflowController

class CertificationWorkflowModel extends RPTWorkflowController {
    @Service('RPTCertificationWorkflowService')
    def svc;

    @Service('RPTCertificationService')
    def certSvc;

    def getService(){
        return svc;
    }

    String getFileType() {
        return 'rptcertification';
    }

    def getSections() {
        return [];
    }

    def getOpener() {
        return Inv.lookupOpener(entity.opener+':open', [entity: certSvc.openCertification(entity.objid)])
    }

    def onupdate = {entity ->
        certSvc.update(entity);
        binding.refresh('opener')
    }

    def initModify() {
        return Inv.lookupOpener('rptcertification:modify', [
            entity: certSvc.openCertification(entity.objid),
            onupdate: onupdate,
        ])
    }

    def viewLogs() {
        return Inv.lookupOpener('rptcertication:tasks', [entity: entity]);
    }

}