package com.rameses.gov.etracs.rptis.report.models;

import com.rameses.rcp.annotations.*
import com.rameses.rcp.common.*
import com.rameses.osiris2.client.*
import com.rameses.osiris2.reports.*;

public class GenderPropertyReportModel extends com.rameses.gov.etracs.rpt.report.AsyncReportController
{
    @Service('RPTReportGenderPropertyService') 
    def svc 

    String title = 'Properties by Gender'
    String reportPath = 'com/rameses/gov/etracs/rptis/reports/';

    def reporttypes = [
        [id: 'summary', caption: 'Summary', reportName: 'property_gender_summary.jasper']
    ]

    String getReportName() {
        return reportPath + entity.reporttype?.reportName
    }
    
    void buildReportData(entity, asyncHandler){
        svc.getReportData(entity, asyncHandler)
    }
    
    Map getParameters(){
        return data.parameters;
    }
    
   def formControl = [
        getFormControls: {
            return [
                new FormControl( "combo", [captionWidth:110, caption:'Report Type', name:'entity.reporttype', items:'reporttypes', expression:'#{item.caption}', preferredSize:'0,21', required:true, allowNull:false]),
            ]    
        },
   ] as FormPanelModel;

}

