package com.rameses.gov.etracs.rptis.report.models;


import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.reports.*;
import com.rameses.etracs.shared.*;

class NATBListingModel extends com.rameses.gov.etracs.rpt.report.AsyncReportController 
{
    @Service('RPTReportNatbService') 
    def svc

    String title = 'List of Notice of Assessment and Tax Bill';
    String reportPath = 'com/rameses/gov/etracs/rptis/reports/';
    
    def showPostingType = false;

    def reportformats = [
        [code: 'cover',  caption: 'Cover Letter', reportname: 'natb_cover.jasper'],
        [code: 'list',  caption: 'Listing', reportname: 'natb_listing.jasper'],
    ];
         
    def periods = [
        [code:'monthly', name:'Month'],     
        [code:'yearly', name:'Year'], 
    ];
    
    
    String getReportName() {
        return reportPath + entity.reportformat.reportname;
    }
    
    def months;

    def getFormControl(){
        return [
            new FormControl( "combo", [captionWidth:110, caption:'Report Format', name:'entity.reportformat', required:true, items:'reportformats', allowNull:false, expression:'#{item.caption}']),
            new FormControl( "integer", [captionWidth:110, caption:'Year', name:'entity.year', required:true]),
            new FormControl( "combo", [captionWidth:110, caption:'Month', name:'entity.month', required:true, depends:'entity.reporttype,entity.qtr', items:'months', expression:'#{item.caption}', dynamic:true]),
            new FormControl( "separator", [preferredSize: '0,23']),
            new FormControl( "text", [captionWidth:110, caption:'Submitted thru', name:'entity.submittedthru.name']),
            new FormControl( "text", [captionWidth:110, caption:'Job Title', name:'entity.submittedthru.title']),
        ]
    }
    
    def initReport() { 
        def outcome = super.initReport();         
        entity.period = periods[0]; 
        months = dtSvc.getMonths(); 
        entity.date = dtSvc.getServerDate();
        entity.reportformat = reportformats[0];
        entity.submittedthru = [:]
        return outcome; 
    } 
    
    void buildReportData(entity, asyncHandler){
        svc.buildReport(entity, asyncHandler);
    } 
} 