package com.rameses.gov.etracs.rptis.report.models;


import com.rameses.rcp.annotations.*
import com.rameses.rcp.common.*
import com.rameses.osiris2.client.*
import com.rameses.osiris2.reports.*;

public class PropertyTracerCertificationModel extends AbstractCertificationModel
{
    @Service('RPTCertificationPropertyTracerService')
    def svc;
    
    
    def getService(){
        return svc;
    }

    def reportPath = 'com/rameses/gov/etracs/rpt/report/certification/'
    String reportName = reportPath + 'certification_property_tracer.jasper'

    void validateFaas(faas) {
        super.validateFaas(faas)
        if (!'land'.equalsIgnoreCase(faas.rputype)) {
            throw new Exception('FAAS selected is invalid. Only Land property is allowed.')
        }
    }

    Map getParameters(){
        return [REPORTTITLE:'Property Tracer']
    }
    
    def getCertificationTypes(){
        return [
            [type:'byfaas', caption:'By FAAS'],
        ]
    }
    
}