package com.rameses.gov.etracs.rptis.report.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.reports.*;

class TMCRReportModel extends com.rameses.gov.etracs.rpt.report.AsyncReportController
{
    @Service('RPTReportTMCRService') 
    def svc;
    
    String title = 'Tax Mapping Control Roll Report';
    
    def reportformats = [
        [id: 'STANDARD', caption: 'STANDARD', reportname: 'tmcr.jasper'],
        [id: 'MODIFIED', caption: 'MODIFIED', reportname: 'tmcr_modified.jasper'],
        [id: 'SIMPLIFIED', caption: 'SIMPLIFIED', reportname: 'tmcr_simplified.jasper'],
        [id: 'DETAILED', caption: 'DETAILED', reportname: 'tmcr_detailed.jasper'],
    ]

    def reporttypes = ['GR', 'MAINTENANCE'];

    String getReportName() {
        def path = 'com/rameses/gov/etracs/rpt/report/';
        return path + entity.format.reportname;
    } 

    def initReport(){
        entity.ry = svc.getCurrentRy();
        return 'default'
    }
    
    void buildReportData(entity, asyncHandler){
        svc.getReportData(entity, asyncHandler);
    }
    
    def formControl = [
        getFormControls: {
            return [
                new FormControl( "combo", [captionWidth:110, caption:'Format', name:'entity.format', allowNull: false, items:'reportformats', expression:'#{item.caption}', preferredSize:'0,21']),
                new FormControl( "combo", [captionWidth:110, caption:'Report Type', name:'entity.reporttype', emptyText:'ALL', items:'reporttypes', preferredSize:'0,21']),
                new FormControl( "combo", [captionWidth:110, caption:'LGU', name:'entity.lgu', required:true, allowNull:false, items:'lgus', expression:'#{item.name}']),
                new FormControl( "combo", [captionWidth:110, caption:'Barangay', name:'entity.barangay', required:true, allowNull:false, items:'barangays', expression:'#{item.name}', depends:'entity.lgu', dynamic:true]),
                new FormControl( "integer", [captionWidth:110, caption:'Revision Year', name:'entity.ry', required:true, preferredSize:'50,21']),            
                new FormControl( "text", [captionWidth:110, caption:'Section', name:'entity.section', preferredSize:'50,19', required:true]),
                new FormControl( "separator", [showCaption:false, preferredSize:'0,19']),
                new FormControl( "checkbox", [captionWidth:130, caption:'Exclude Improvements?', name:'entity.excludeimprov', preferredSize:'0,19', required:true, cellPadding:'20,0,0,0']),                
            ]    
        },
   ] as FormPanelModel;
   
    Map getParameters(){
        data.parameters.SECTION = entity.section;
        return data.parameters;
    }
}