package com.rameses.gov.etracs.rptis.master.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;

class MasterListModel extends CrudListModel
{
    // boolean autoResize = false;

    @Service('ProvinceMasterDataSyncService')
    def syncSvc
    
    boolean allowExport = true;
    boolean allowImport = true;
    
    boolean isAllowSync(){
        def allowSync = workunit?.info?.workunit_properties?.allowSync;
        if (allowSync == 'false') return false;
        
        if ('province'.equalsIgnoreCase(OsirisContext.env?.ORGCLASS))
            return true;
        return false;
    }
    
    def importFile(){
        def entity = [:]
        entity.schemaname = schemaName;
        entity.title = workunit?.info?.workunit_properties?.windowTitle;
        return Inv.lookupOpener('rptis_master:import', [entity:entity]);
    }
    
    def exportFile(){
        def entity = [:]
        entity.schemaname = schemaName;
        entity.title = workunit?.info?.workunit_properties?.windowTitle;
        return Inv.lookupOpener('rptis_master:export', [entity:entity]);
    }
    
    void sendToMunicipalities(){
        if (!MsgBox.confirm('Sync data to municipalities?')) return;
        syncSvc.sendToMunicipality([name: schemaName]);
        MsgBox.alert('Data successfully scheduled for sync.')
    }
}
