package com.rameses.gov.etracs.rptis.master.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.gov.etracs.rptis.models.*;

class MemorandaTemplateLookupModel extends ExprLookupEditorModel
{
    @Service('QueryService')
    def query;
    
    def schemaname = 'rptis_memoranda_template';
    
    void init(){
    }
    
    List fetchList(Map params){
        def search = '%';
        if (searchtext) search = '%' + searchtext + '%';
        def filter = [_schemaname:schemaname];
        filter.where = ['code LIKE :search', [search: search]];
        filter.orderBy = 'code';
        return query.getList(filter);
    }
    
    def getVariables(){
    }
    
    def buildParamList(){
        params = [];
        selectedItem.item.fields.each{
            params << [param:it];
        }
    }    
    
    Column[] getColumns() {
        return [
            new Column(name:"code", caption:"Code", width:80),
            new Column(name:"template", caption:"Template", width:150),
        ]
    }
        
}