package com.rameses.gov.etracs.rptis.models;
        

import com.rameses.rcp.annotations.* 
import com.rameses.rcp.common.* 
import com.rameses.osiris2.client.*
import com.rameses.osiris2.common.*

class FAASHistoryListModel
{
    @Binding
    def binding;
    
    def svc;
    
    def entity;
    def list;
    def selectedItem;
    
    String title = 'FAAS History'
    
    void init(){
        list = svc.getHistory(entity.objid);
        listHandler?.load();
    }
    
    void refresh(){
        init();
    }
    
    
    def listHandler = [
        fetchList : { return list; },
        getColumns : { svc.getHistoryColumns() }
    ] as BasicListModel

    def onadd = {
        refresh();
    }

    def onupdate = {
        refresh();
    }

    def createHistory() {
        return Inv.lookupOpener('rpu_history:create', [
            faas: entity, 
            histories: list,
            onadd: onadd,
        ])
    }

    def openHistory() {
        return Inv.lookupOpener('rpu_history:open', [
            entity: selectedItem,
            onupdate: onupdate,
        ])
    }

    
    
}