package com.rameses.gov.etracs.rptis.models;
        

import com.rameses.rcp.annotations.* 
import com.rameses.rcp.common.* 
import com.rameses.osiris2.client.*
import com.rameses.osiris2.common.*

class FAASHistoryModel
{
    @Binding
    def binding;

    @Service('FAASService')
    def faasSvc;
    
    @Service('FAASHistoryService')
    def svc;
    
    @Caller 
    def caller;

    def histories;
    def onadd = {};
    def onupdate = {};
    def entity;
    def mode = 'CREATE';
    def quarters = [1,2,3,4];
    def txntypes;
    def modify = false;

    void create() {
        mode = 'CREATE';
        entity = svc.init([faas: caller.entity, histories: histories]);;
        loadTxnTypes();
    }

    void open() {
        mode = 'READ';
        def history = svc.open(entity);
        entity.putAll(history);
        loadTxnTypes();
    }

    void edit() {
        mode = 'EDIT';
    }

    void modify() {
        edit();
        modify = true;
    }

    void save() {
        entity.faasid = caller.entity?.objid
        entity.rpuid = caller.entity?.rpu?.objid
        if (mode == 'CREATE') {
            entity = svc.create(entity);
            onadd(entity);
        } else {
            entity = modify ?  svc.modify(entity) :  svc.update(entity);
            onupdate(entity);
        }
        mode = 'READ';
    }

    void approve() {
        if (!MsgBox.confirm('Approve history?')) return;
        entity.putAll(svc.approve(entity));
        onupdate(entity);
    }



    def loadTxnTypes() {
        txntypes = faasSvc.getTxnTypes();
    }
}