package com.rameses.gov.etracs.rptis.models;
        
import com.rameses.rcp.annotations.* 
import com.rameses.rcp.common.* 
import com.rameses.osiris2.client.*
import com.rameses.osiris2.common.*

public class FAASOwnerReconcileModel
{
    @Binding
    def binding;

    @Service('FAASOwnerReconcileService')
    def svc;

    String title = 'Reconcile FAAS Ownership'

    def entity = [:];
    def list = [];
    def selectedItem;

    def listHandler = [
        getRows: { list.size() },
        fetchList: { list }
    ] as BasicListModel;

    def getLookupReconciledEntity() {
        return Inv.lookupOpener('entity:lookup', [
            onselect: {
                if (entity.taxpayer.objid == it.objid) {
                    def msg = 'Selected item is invalid.\n';
                    msg += 'Entity to reconcile should not be equal to entity to retain.';
                    throw new Exception(msg);
                }
                entity.reconciledentity = it;
                list = svc.getFaasListToReconcile(it);
                listHandler.reload();
            },
            onempty: {
                entity.reconciledentity = null;
                binding.refresh();
            }
        ])
    }    

    void clearEntries() {
        list = [];
        entity.reconciledentity = null;
        listHandler.reload();
        binding.refresh();
        binding.focus('entity.reconciledentity');
    } 
    
    void removeItem() {
        if (!MsgBox.confirm('Remove selected item?')) return;
        list.remove(selectedItem);
        listHandler.reload();
    }

    void reconcileFAASOwner() {
        if (!MsgBox.confirm('Reconcile property owner for all items?')) return;
        svc.reconcileOwners([
            entity: entity.taxpayer, 
            list: list,
        ]);
        list = [];
        entity.reconciledentity = null;
        listHandler.reload();
    }
    
    def getOrgclass() {
        println 'OsirisContext.env => ' + OsirisContext.env;
        return OsirisContext.env.ORGCLASS;
    }
    
    
}