package com.rameses.gov.etracs.rptis.models;

import com.rameses.rcp.common.*
import com.rameses.rcp.annotations.*
import com.rameses.osiris2.client.*
import com.rameses.osiris2.common.*
        
class LandParcelMonitoringModel 
{
    @Service('TaxmappingListService')
    def svc; 
            
    @Service('LGUService')
    def lguSvc;
            
    String title = 'Land Parcels Monitoring';
            
    def lgu;
    def barangay;
            
    def rylist;
    def ry;
            
    def list;
    def selectedItem;
    def selectedFaas;
    def appEnv;
    def json_service_path;

    def states = ['CURRENT', 'CANCELLED'];
    def recordTypes = ['GR', 'MAINTENANCE'];

    def state = states[0];
    def recordtype;

            
    @PropertyChangeListener
    def listener = [
        '.*' : { reload() },
    ]
            
    void init(){
        rylist = svc.getRevisionYears().unique();
        appEnv = com.rameses.rcp.framework.ClientContext.currentContext.appEnv; 
        json_service_path = appEnv['app.host'] +'/'+ appEnv['app.cluster'] +'/json'
    }
            
    void reload(){
        list = svc.getList(getParams());
        listHandler?.load();
    }


    def getParams() {
        def params = [:];
        params.objid = barangay.objid;
        params.ry = ry;
        params.state = state;
        params.recordtype = recordtype;
        return params;
    }
            
            
    def listHandler = [
        fetchList : {return list}
    ] as BasicListModel
        
        
    def getLgus(){
        return lguSvc.getLgus();
    }
            
            
    def getBarangays(){
        if (! lgu)
        return [];
        return lguSvc.lookupBarangaysByRootId(lgu.objid);
    }
    
    def faasListHandler = [
        fetchList : {
            if (!selectedItem) return [];
            return svc.getFaasList([item: selectedItem, params: getParams()]);
        }
    ] as BasicListModel;
    
    def getSketch() {
        return 'http://' + json_service_path + '/etracs25/FAASReportService.getSketch?objid=' + selectedFaas.objid;
    }
            
}
        