package com.rameses.gov.etracs.rptis.models;

import com.rameses.rcp.annotations.* 
import com.rameses.rcp.common.* 
import com.rameses.osiris2.client.* 
import com.rameses.osiris2.common.* 
import com.rameses.gov.etracs.rptis.util.RPTUtil;

class RPUInfoRestrictionModel extends SubPageModel
{
    @Service('DateService')
    def dtSvc;
    
    @Service('QueryService')
    def querySvc
    
    def selectedItem;
    def restrictions = [];
    
    void init(){    
        def query = [
            _schemaname: 'faas_restriction',
            findBy: [parent_objid: entity.objid],
            orderBy: 'txndate DESC'
        ]
        restrictions = querySvc.getList(query);
    }
    
    void afterModeChanged(){
        listHandler.reload();
    }

    
    def listHandler = [
        fetchList   : { restrictions },
        onOpenItem : {item, colname ->
            return Inv.lookupOpener('faas_restriction:open', [entity: item]);
        }
    ] as BasicListModel 
    
    
}    
    