package com.rameses.gov.etracs.rptis.models;

import com.rameses.rcp.annotations.* 
import com.rameses.rcp.common.* 
import com.rameses.osiris2.client.* 
import com.rameses.osiris2.common.* 
import com.rameses.gov.etracs.rptis.util.RPTUtil;

class RPUMachInfoActualUseModel extends SubPageModel
{
    def rpuSvc;
    
    def getClassifications(){
        return rpuSvc.getClassifications();
    }    
    
    
    void init(){
        entity.rpu.classification = classifications.find{it.objid == entity.rpu.classification?.objid}
    }
    
    
    void calculateAssessment(){
        super.calculateAssessment();
        listHandler.load();
        binding.refresh('.*');
    }
    
    
    /*-------------------------------------------------------------
     *
     * MAIN PAGE
     *
     ------------------------------------------------------------- */
     def selectedItem;
     
     def getLookupActualUse(){
         return InvokerUtil.lookupOpener('machassesslevel:lookup', [
             lguid    : entity.lguid,
             barangayid : entity.rp.barangayid,
             ry       : entity.rpu.ry,
         ])
     }
     
     def listHandler = [
         getRows   : { return 25 },
             
         fetchList : { return entity.rpu.machuses },
                 
         createItem : { return [
            objid          : 'MU' + new java.rmi.server.UID(),
            machrpuid		: entity.rpu.objid,
            taxable         : true,
            basemarketvalue	: 0.0,
            marketvalue		: 0.0,
            assesslevel		: 0.0,
            assessedvalue	: 0.0,
            isnew           : true,
            machines            : [],
         ]},
                 
         validate  : { li ->
            def mu = li.item;
            RPTUtil.required('Actual Use', mu.actualuse)
            validateDuplicateUse(mu);
            if (!mu.isnew){
                calculateAssessment()
            }
         },
                 
         onAddItem : { mu ->
            entity.rpu.machuses.add(mu);
         },
         
         onRemoveItem :{ mu ->
            if (MsgBox.confirm('Delete selected item?')){
                entity.rpu.machuses.remove(mu);
                if (!entity.rpu._machuses) 
                    entity.rpu._machuses = [];
                entity.rpu._machuses.add(mu)
                calculateAssessment();
                return true;
            }
            return false;
         },
         
     ] as EditorListModel 
     
     void validateDuplicateUse(machuse) {
        def duplicate = entity.rpu.machuses.find {
            it.objid != machuse.objid &&
            it.actualuse.objid == machuse.actualuse.objid &&
            RPTUtil.toBoolean(it.taxable, true) == RPTUtil.toBoolean(machuse.taxable, true)
        }
        if (duplicate) {
            def taxability = machuse.taxable ? ' TAXABLE ' : ' NON-TAXABLE ';
            def msg = 'Duplicate ' + taxability + machuse.actualuse.name + ' use is not allowed.';
            throw new Exception(msg);
        }
     }

    void afterModeChanged(){
        listHandler.reload();
    }
    
}    
