package com.rameses.gov.etracs.rptis.models;
        
import com.rameses.rcp.annotations.* 
import com.rameses.rcp.common.* 
import com.rameses.osiris2.client.*
import com.rameses.osiris2.common.*

public class RedFlagListModel extends com.rameses.seti2.models.CrudListModel {
    @Service('RPTRedFlagService')
    def svc; 


    def open() {
        if (!selectedItem) return;
        def task = null;
        def schemaname = null;
        def entity = [:];

        if (selectedItem.info?.parentschema) {
            schemaname = selectedItem.info?.parentschema;
            task = svc.getCurrentParentTask(selectedItem);
            if (!task) throw new Exception(getMessage(schemaname));
            entity = [objid: selectedItem.parentid, taskid: task.objid];
        } else {
            schemaname = 'faas';
            task = svc.getCurrentTask(selectedItem);
            if (!task) throw new Exception(getMessage(schemaname));
            entity = [objid: selectedItem.refid, taskid: task.objid];
        }
        return Inv.lookupOpener(schemaname+':open', [entity: entity]);
    }

    def getMessage(schemaname) {
        return 'Open task for ' + schemaname + ' does not exist or has already been deleted.';
    }
}


