package com.rameses.gov.etracs.rptis.rysetting.models;

import com.rameses.rcp.annotations.*
import com.rameses.rcp.common.*
import com.rameses.osiris2.client.*
import com.rameses.osiris2.common.*
import com.rameses.gov.etracs.rptis.util.*;
import com.rameses.gov.etracs.rptis.interfaces.*;


public class BldgTypeInfoModel implements SubPage
{
    @Binding
    def binding 
    
    //BldgRYSettingService
    def service;
    
    def entity;
    def mode = 'read';
    
        
    void init(){
        bldgTypes = service.getBldgTypes(entity);
    }
    
    public void modeChanged(String mode){
        this.mode = mode;
        binding?.refresh();
    }
    
    
    /*---------------------------------------------------------------------
    *
    * BldgType Support
    *
    ---------------------------------------------------------------------*/
    @PropertyChangeListener
    def listener = [
        'selectedBldgType.residualrate' : {
            service.saveBldgType(selectedBldgType);
        },
        'selectedBldgType.usecdu' : {
            service.saveBldgType(selectedBldgType);
            initDepreciationHandler()
        },
        'storeyadjtype' : {
            if (selectedBldgType) {
                selectedBldgType.storeyadjtype = storeyadjtype;
                service.saveBldgType(selectedBldgType);
            }
        },
    ]
    
    def bldgTypes = [] 
    def selectedBldgType
    
    void setSelectedBldgType( selectedBldgType ) {
        this.selectedBldgType = selectedBldgType
        baseValueType = selectedBldgType?.basevaluetype
        initBaseValueHandler()
        initDepreciationHandler()
        binding.refresh('baseValueType') 
        
        setStoreyadjtype(selectedBldgType ? selectedBldgType.storeyadjtype : multistoreyadjtypes[0]);
        storeyadjustments = service.getStoreyAdjustments(selectedBldgType)
        storeyAdjListHandler.load();
        binding.refresh('storeyadjtype');

        depreciations = service.getDepreciations(selectedBldgType)
        depreciationListHandler.load();
        binding.requestFocus('selectedBldgType');
    }
    
    def bldgTypeListHandler = [
        createItem : { return createBldgType() },
        getRows    : { return (bldgTypes.size() <= 25 ? 25 : bldgTypes.size() + 1)},
        validate       : { li -> 
            def bldgType = li.item
            RPTUtil.required( bldgType.code, 'Code' )
            RPTUtil.required( bldgType.name, 'Bldg Type' )
            checkDuplicateBldgType( bldgType )
            if ( !bldgType.objid ) bldgType.objid = RPTUtil.generateId('BT')
            service.saveBldgType( bldgType )
        },
                
        onRemoveItem   : { bldgType -> 
            if( MsgBox.confirm('Remove item?') ) {
                service.deleteBldgType( bldgType )
                bldgTypes.remove( bldgType )
                return true;
            }
            return false;
        },
                
        onAddItem      : { item -> bldgTypes.add( item ) },
        fetchList      : { return bldgTypes },
    ] as EditorListModel
    
    
    void checkDuplicateBldgType( bldgType ) {
        def item = bldgTypes.find{ it.objid != bldgType.objid && it.code == bldgType.code  }
        if( item ) throw new Exception('Duplicate code is not allowed.')    
        item = bldgTypes.find{ it.objid != bldgType.objid && it.name == bldgType.name }
        if( item ) throw new Exception('Duplicate name is not allowed.')    
    }
    

    /*---------------------------------------------------------------------
    *
    * Depreciation Support
    *
    ---------------------------------------------------------------------*/
    def depreciationHandler
    
    void initDepreciationHandler() {
        depreciationHandler = Inv.lookupOpener('bldgtype:depreciation',[bldgType:selectedBldgType, mode:mode, service:service])
    }
    
    
    /*---------------------------------------------------------------------
    *
    * BldgKind Support
    *
    ---------------------------------------------------------------------*/
    def baseValueType
    def baseValueHandler
    def selectedBaseValue
    def searchtext;
   
    void search(){
        if (baseValueHandler){
            def params = [bldgtypeid:selectedBldgType.objid, searchtext:searchtext]
            baseValueHandler.handle.search(params);
        }
    }
    
    void setBaseValueType( baseValueType ) {
        this.baseValueType = baseValueType
        if( selectedBldgType && selectedBldgType.objid ) {
            selectedBldgType.basevaluetype = baseValueType
            service.saveBldgType( selectedBldgType )
            initBaseValueHandler()
        }
    }
    
    void initBaseValueHandler() {
        baseValueHandler = null
        if( baseValueType ) {
            def openerType = 'basevaluetype:' + baseValueType
            baseValueHandler = InvokerUtil.lookupOpener(openerType, [bldgType:selectedBldgType, mode:mode, service:service] )
        }
    }
    
    
    List getBaseValueTypes() {
        return ['fix','range','gap']
    }
    
     void validateRate( rate ) {
        if( rate < 0.0 ) throw new Exception('Rate must be greater than or equal to zero.')
        if( rate > 100) throw new Exception('Rate must not exceed 100.00')
    }       
    
    Map createBldgType() {
        return [
            code            : null,
            name            : null,
            bldgrysettingid : entity.objid,
            bldgrysetting   : [objid: entity.objid],
            basevaluetype   : 'fix', 
            residualrate    : 0.0,
            multistoreyadjustments : [],
            depreciations : [],
        ]
    }
    
    Map createDepreciation(){
        return [
            objid           : RPTUtil.generateId('BD'),
            bldgtypeid      : selectedBldgType?.objid,
            bldgrysettingid : entity.objid,
            isnew           : true,
        ]
    }
 
        
    def isFirstItem( list ) {
        return list.size() == 0
    }    
        
    def isLastItem( list, item ) {
        def index = list.indexOf( item )
        if( index < 0 ) 
            index = list.size()
        else
            index += 1 
        return list.size() == index 
    }



    /*---------------------------------------------------------------------
    *
    * MULTI-STOREY ADJUSTMENT SUPPORT
    *
    ---------------------------------------------------------------------*/
    def multistoreyadjtypes = ['bytype', 'bykind'];
    def storeyadjtype = null;
    def selectedStoreyAdj;
    def storeyadjustments = [];

    void reloadStoreyAdjustments() {
        storeyadjustments = service.getStoreyAdjustments(selectedBldgType);
        storeyAdjListHandler.load();
    }

    void setStoreyadjtype(adjtype) {
        this.storeyadjtype = adjtype;
        selectedBldgType.storeyadjtype = adjtype
    }

    def storeyAdjListHandler = [
        fetchList : { storeyadjustments },

        createItem : { 
            return [
                objid: 'BTM' + new java.rmi.server.UID(),
                bldgrysettingid: selectedBldgType?.bldgrysettingid,
                bldgtypeid: selectedBldgType?.objid,
                isnew: true,
            ] 
        },

        validate     : { li -> 
            def item = li.item 
            if ('bytype' == selectedBldgType.storeyadjtype) {
                validateDuplicate(item, {a, b -> a.objid != b.objid && a.floorno == b.floorno })
            } else {
                validateDuplicate(item, {a, b -> a.objid != b.objid && a.floorno == b.floorno && a.rate == b.rate })
            }
        },
        
        onAddItem : { item -> 
            service.saveStoreyAdjustment(item);
            item.isnew = false;
            storeyadjustments << item;
        },

        onCommitItem: {item ->
            service.saveStoreyAdjustment(item);
        },

        onRemoveItem : { item -> 
            if( MsgBox.confirm("Delete selected item?") ) {
                service.deleteStoreyAdjustment(item);
                storeyadjustments.remove(item);
                return true;
            }
            return false;
        },
    ] as EditorListModel   


    void validateDuplicate(item, validator) {
        def dup = storeyadjustments.find{validator(it, item)}
        if (dup) throw new Exception('Duplicate entry for Floor ' + item.floorno + ' is not allowed.');
    }


    /* STOREY ADJUSTMENT BLDG KIND */
    def selectedBldgKind;
    def storeyadjbldgkinds = []

    def bldgKindListHandler = [
        fetchList: { 
            storeyadjbldgkinds = service.getStoreyAdjustmentBldgKinds(selectedStoreyAdj);
            return storeyadjbldgkinds;
        },

        createItem: { return [
            objid: 'BTMB' + new java.rmi.server.UID(),
            bldgrysettingid: selectedBldgType.bldgrysettingid,
            bldgtypeid: selectedBldgType.objid,
            parent: [objid: selectedBldgType.objid],
            parentid: selectedStoreyAdj.objid,
            floorno: selectedStoreyAdj.floorno,
        ]},

        validate     : { li -> 
            def item = li.item 
            item.bldgkindid = item.bldgkind.objid;
            validateDuplicate(
                item, 
                {a, b -> a.objid != b.objid && a.bldgkindid == b.bldgkindid && a.floorno == b.floorno }
            );
            
        },
        
        onAddItem : { item -> 
            item.rate = selectedStoreyAdj.rate;
            service.saveStoreyAdjustmentBldgKind(item);
            storeyadjbldgkinds << item;
        },

        onRemoveItem : { item -> 
            if( MsgBox.confirm("Delete selected item?") ) {
                service.deleteStoreyAdjustmentBldgKind(item);
                storeyadjbldgkinds.remove(item);
                return true;
            }
            return false;
        },

    ] as EditorListModel;
}