package com.rameses.gov.etracs.bpls.business;

import com.rameses.rcp.annotations.*
import com.rameses.rcp.common.*
import com.rameses.osiris2.client.*
import com.rameses.osiris2.common.*
import java.rmi.server.*

public class  BusinessGeneralInfoModel  {

    @Binding
    def binding;

    @Service("BusinessMasterService")
    def svc;

    @Service("BusinessPermitService")
    def permitSvc;

    @Service("BusinessLobService")
    def lobSvc;

    @Service("EntityService")
    def entitySvc;

    @Service("PersistenceService")
    def persistenceService;

    String title = "General Info";
    String entityName = "businessinfo:generalinfo";

    def entity;
    def selectedLob;

    def lobModel = [
        fetchList: { o->
            if( !entity.lobs) {
                entity.lobs = lobSvc.getActiveLobs( [businessid:entity.objid] );
            }    
            entity.lobs.each {
                it.main = ( it.lobid  == entity.mainlobid )? true: false;  
            }
            return entity.lobs;
        },
        isAllowAdd: { 
            return false; 
        },        
        onColumnUpdate: { item, col->
            updateMainLob( item );
        }
    ] as EditorListModel;


    def issuePermit() {
        if( entity.permit ) {
            throw new Exception("Permit already exists!");
        }
        else {
            def h = { o->
                entity.permit = o;
                def op = InvokerUtil.lookupOpener( "businesspermit:print" , [entity:o] );
                op.target = 'self';
                binding.fireNavigation( op );
            }
            def p = [businessid: entity.objid];
            return Inv.lookupOpener("business:issuepermit", [handler:h, entity: p  ]);
        }
    }

    def printPermit() {
        return InvokerUtil.lookupOpener( "businesspermit:print" , [entity:entity.permit] );
    }

    def rebuildPermit() {
        if( MsgBox.confirm("This will replace existing data with the latest business information. Proceed?")) {
            permitSvc.rebuildPermit( entity.permit );
            MsgBox.alert("Rebuild successful");
        }
    }

    def reissuePermit() {
        if( MsgBox.confirm("You are about to supersede existing permit. Proceed?")) {
            def m = [businessid: entity.objid];
            m.permittype = entity.permit.permittype;
            def p = permitSvc.reissuePermit( m );
            binding.refresh();
            return InvokerUtil.lookupOpener( "businesspermit:print" , [entity:p] );
        }
    }

    void reloadOwner() {
        if(!entity.owner.objid) 
            throw new Exception("No owner assigned");
        def owner = entitySvc.open([objid:entity.owner.objid]);
        entity.owner = owner;
    }
    
    void updateMainLob(def item) {
        if(!item.objid) return;
        def p = [_schemaname: "business"];
        p.findBy = [objid: entity.objid ];
        p.mainlobid = item.lobid;
        persistenceService.update( p );
        entity.lobs.each {
            it.main = false;
        }
        selectedLob.main = true;
        entity.mainlobid = item.lobid;
        binding.refresh("entity.mainlobid");
    }

}