package com.rameses.gov.etracs.bpls.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
        
class BplsMultiCashReceiptModel extends com.rameses.enterprise.treasury.cashreceipt.MultiCashReceiptModel {

    @Script("BusinessAssessmentInfoUtil")
    def assessmentInfo;

    @Service("BusinessCashReceiptService")
    def cashRctSvc;
            
    //we specify this so print detail will appear.
    String entityName = "misc_cashreceipt";
    String title = "Business Permit and Licensing";

    def excessAcct;
            
    void init() {
        super.init();
        boolean pass = false;
        def m = [:];
        m.onselect = { o->
            entity.putAll( o );
            pass = true;
        }
        Modal.show( Inv.lookupOpener( "cashreceipt:business:lookup", m ) );
        if ( !pass ) {
            try {
                throw new BreakException();
            } 
            finally {
                if ( mainProcessHandler?.back ) {
                    mainProcessHandler.back(); 
                } 
            } 
        }
                
        //load apps
        def app = [applicationid:entity.applicationid];
        def z = cashRctSvc.findInfo( app );
        entity.putAll(z); 
        loadBilling( entity );
    }
            
    void loadBarcode() {
        def app = [appno:barcodeid];
        def m = cashRctSvc.findInfo( app );
                
        entity.applicationid = m.applicationid;
        entity.businessid = m.businessid;
        entity.apptype = m.apptype;
        entity.appyear = m.appyear;
        entity.dtfiled = m.dtfiled;
        entity.appno = m.appno;
        entity.remarks = m.particulars;
                
        if(!entity.payer) entity.payer = m.payer;
        if(!entity.paidby) entity.paidby = m.paidby;
        if(!entity.paidbyaddress) entity.paidbyaddress = m.paidbyaddress;

        if(barcodeparams) {
            def pmt = [payment:barcodeparams];
            if(!pmt.payment.option) {
                if(pmt.payment.qtr!=null) {
                    pmt.payment.option = 'FULLQTR';
                }
                else {
                    pmt.payment.option = 'FULLQTR';
                }
            }
            loadBilling( pmt );
        }
        else {
            loadBilling( entity );
        }
    }          
            
    def loadBilling = { m ->
        def r = [:];
        r.app = [apptype:entity.apptype, appyear:entity.appyear, dtfiled:entity.dtfiled, appno:entity.appno]; 
        r.billdate = entity.receiptdate;
        r.applicationid = entity.applicationid;
        r.payment = m.payment; 
        if ( !r.payment && info ) { 
            r.payment = info;
        } 
        def z = cashRctSvc.getBillingForPayment( r ); 
        if (z.excess) {
            excessAcct = z.excess.account; 
        } else {
            excessAcct = null; 
        } 
                
        entity.taxfees = z.taxfees;
        entity.totals = z.totals;
        entity.expirydate = z.expirydate;
        entity.items = z.items;             
        entity.amount = entity.totals.total;
        
        def years = entity.taxfees.collect{ it.iyear }.findAll{( it )}.unique(); 
        entity._mix_assessment_years = ( years.size() > 1 ); 
        
        assessmentInfo.refresh();
        super.updateBalances();
    }

    def showPaymentOption() {
        def h = { pmt-> 
            loadBilling([ payment: pmt ]);
        }
        return Inv.lookupOpener("cashreceipt:payoption", [handler:h] );
    }
            
    def showReceipt() {
        return Inv.lookupOpener("businessreceipt:view", [entity:entity]);
    }
            
    void removeTaxcredits() {
        def taxcredits = entity.items.findAll{ it.type=='taxcredit' }
        if (taxcredits) entity.items.removeAll( taxcredits ); 
    } 
            
    void validateBeforePost() {}
            
    void beforeUpdateBalance() { 
        removeTaxcredits(); 
    } 
            
    void postError() {
        removeTaxcredits();
    } 
            
    void beforePost() { 
        removeTaxcredits(); 
                
        if(entity.totalcredit > 0) {
            if (excessAcct?.objid == null) 
            throw new Exception('Tax credit account is required. Please check ExcessPayment rule'); 
                    
            entity.items << [item: excessAcct, amount: entity.totalcredit, remarks:'', type:'taxcredit', indexno:200];
        } 
    } 
} 
