package com.rameses.gov.etracs.bpls.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.BreakException;

class BuildPaymentItemModel {

    @Service('BuildPaymentItemService')
    def service; 
    
    def invoker;
    def title;
    
    def entity;
    def application;
    def payments;
    def receiptItems;
    int step;

    def init( inv ) {
        step = 1;
        entity = [:];
        payments = [];
        receiptItems = []; 

        invoker = inv;
        title = inv?.properties?.formTitle;
        return step;
    }

    void setApplication( app ) {
        if ( app ) {
            def _payments = service.getPayments([ applicationid: app.objid ]); 
            if ( !_payments ) {
                MsgBox.alert("No available payments for this application");
                throw new BreakException();
            }
            
            app.expr = (app.appno +' - '+ app.tradename);

            this.application = app; 

            payments.clear();
            payments.addAll( _payments );
            _payments.clear();
        }
        else {
            this.application = null; 
            payments.clear();
        }

        receiptItems.clear(); 
        paymentListHandler.reload(); 
    }
    
    
    def selectedPayment;
    def paymentListHandler = [
        fetchList: {
            return payments; 
        }
    ] as DataListModel;
    
    
    def cancel() {
        if ( MsgBox.confirm('You are about to close this window. Proceed ?')) {
            return '_close'; 
        }
        return null; 
    }
    def moveBack() {
        step = Math.max( 1, step-1);
        return step.toString();
    }
    def moveNext() {
        if ( step == 1 ) {
            return moveToStep2();
        } else if ( step == 2 ) {
            return moveToStep3();
        }
    }
    
    def moveToStep2() {
        if ( !selectedPayment ) 
            throw new Exception('Please select a payment first');
        
        selectedPayment.paymentid = selectedPayment.objid; 
        def items = service.getPaymentItems( selectedPayment );
        if ( items ) {
            def msg = 'Payment reference '+ selectedPayment.refno +' already contains items'; 
            throw new Exception( msg.toString() );
        } 
        
        items = service.getReceiptItems( selectedPayment );
        if ( !items ) throw new Exception("No available receipt items");

        def param = [ applicationid : application.objid ]; 
        items.each{ o-> 
            param.accountid = o.item?.objid; 
            
            def receivables = service.getReceivables( param );
            if ( receivables && receivables.size() == 1 ) {
                setReceivable( o, receivables.first() ); 
            }
        }
        
        receiptItems.clear(); 
        receiptItems.addAll( items ); 
        return (step = 2).toString();
    }
    
    def moveToStep3() { 
        if ( finalReceiptItems == null ) {
            finalReceiptItems = [];
        }
        
        finalReceiptItems.clear();
        boolean has_unmap_item;
        receiptItems.each{
            if ( it.receivable?.objid ) {
                finalReceiptItems << it; 
            } 
            else {
                has_unmap_item = true; 
            }
        }
        
        if ( !finalReceiptItems ) {
            MsgBox.alert("No mapping has been done yet."); 
            return null; 
        }
        if ( has_unmap_item ) {
            boolean b = MsgBox.confirm('There are still unmap items. Do you still want to proceed?');
            if ( !b ) return null; 
        }
        
        return (step = 3).toString();
    }

    def selectedReceiptItem;
    def receiptItemsHandler = [
        fetchList: {
            return receiptItems; 
        }
    ] as DataListModel;

    def finalReceiptItems;
    def finalReceiptItemsHandler = [
        fetchList: {
            return finalReceiptItems; 
        }
    ] as DataListModel;
    
    
    void setReceivable( receiptItem, receivable ) {
        def sb = new StringBuilder();
        sb.append( receivable.iyear ).append(" ");
        sb.append( receivable.account?.title );
        if ( receivable.lob?.objid ) {
            sb.append(" (").append( receivable.lob?.name ).append(")"); 
        }

        receiptItem.receivable = receivable;             
        receiptItem.mappingdescription = sb.toString();
    }
    
    void mapReceivable() {
        if ( !selectedReceiptItem ) {
            MsgBox.alert("Please select an item first"); 
            return;
        }
        
        def param = [:]; 
        param.applicationid = application.objid; 
        param.accountid = selectedReceiptItem.item?.objid; 
        def items = service.getReceivables( param );
        if ( !items ) throw new Exception("No available receivable(s) found");

        boolean pass;
        param.clear(); 
        param.items = items;
        param.handler = { o-> 
            setReceivable( selectedReceiptItem, o ); 
            pass = true; 
        }
        Modal.show('tools_select_receivable', param);
        if ( pass ) {
            receiptItemsHandler.refresh();
        }
    }
    
    void clearMappings() {
        receiptItems.each{
            it.remove('receivable');
            it.remove('mappingdescription'); 
        }
        receiptItemsHandler.refresh();
    }
    
    def post() {
        if ( !finalReceiptItems ) {
            MsgBox.alert("No mapping has been done yet."); 
            return null; 
        }
        
        boolean pass = MsgBox.confirm('You are about to post the receipt items. Proceed ?');
        if ( !pass ) return null; 
        
        def items = [];
        finalReceiptItems.each{ o-> 
            items << [
                objid: o.paymentitemid, 
                parentid: o.paymentid, 
                receivableid: o.receivable.objid, 
                account: o.item, 
                amount: o.amount, 
                lob: o.lob 
            ]; 
        }
        def param = [:];
        param.putAll( application ); 
        param.items = items;
        service.post( param ); 
        
        MsgBox.alert("Successfully posted"); 
        return '_close'; 
    }
}
