package com.rameses.gov.etracs.bpls.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import java.rmi.server.*;
import com.rameses.util.*;

class BusinessApplicationCapturePaymentModel {

    @Service("BusinessCapturePaymentService")
    def service;

    @Script("BusinessAssessmentInfoUtil")
    def assessmentInfo;

    @Service("BusinessCashReceiptService")
    def cashRctSvc;

    @Binding
    def binding;

    def entity = [:];
    def handler;
    def allselected = true;
    def amount = 0.0;
    def app;
    
    void initManual() {
        app = entity;
        entity = [ taxcredit: 0.0 ]; 
        loadBill([:]);
    }

    void loadBill( param ) { 
        def o = app;
        def r = [:];
        r.app = [apptype: o.apptype, appyear: o.appyear, dtfiled: o.dtfiled, appno: o.appno]; 
        r.billdate = o.receiptdate;
        r.applicationid = o.objid;
        
        if ( param.payment ) { 
            r.billdate = entity.refdate; 
            r.payment = param.payment;
        } 

        def z = cashRctSvc.getBillingForPayment( r ); 
        def taxfees = z.taxfees;
        taxfees.eachWithIndex{ oo,idx-> 
            oo.sortorder = (idx * 100) + 100;
        }
        
        entity.taxfees = [];
        taxfees.each { tfi-> 
            def details = null; 
            if ( tfi.details ) { 
                details = tfi.details; 
                details.eachWithIndex{ oo,idx-> 
                    oo.iyear = tfi.iyear;
                    oo.appyear = tfi.appyear;
                    oo.sortorder = tfi.sortorder + (idx+1); 
                }
            } 
            else { 
                tfi.qtr = 0; 
                details = [ tfi ]; 
            } 

            details.each { i->
                def m = [:];
                m.putAll( i );
                m.qtr = i.qtr; 
                m.selected = true;
                m.amtpaid = i.amtdue;
                m.interestpaid  = (i.interest ? i.interest : 0.0);
                m.surchargepaid = (i.surcharge ? i.surcharge : 0.0);
                m.totalpaid = m.amtpaid + m.surchargepaid + m.interestpaid;
                entity.taxfees << m;
            } 
        }
        entity.taxfees.sort{ it.sortorder } 
        entity.amount = entity.taxfees.sum{( it.totalpaid ? it.totalpaid : 0.0 )};    
        listModel.reload();
    }

    def listModel = [
        fetchList: { o->
            return entity.taxfees;
        },
        onColumnUpdate: { o,col-> 
            if ( col == 'selected' ) { 
                if ( o.selected ) {
                    o.amtpaid = o.amtdue;
                    o.surchargepaid = o.surcharge;
                    o.interestpaid = o.interest;
                }
                else {
                    o.amtpaid = 0.0;
                    o.surchargepaid = 0.0;
                    o.interestpaid = 0.0;
                }
            }
            o.totalpaid = o.amtpaid + o.surchargepaid + o.interestpaid;
            entity.amount = NumberUtil.round( entity.taxfees.sum{ it.totalpaid } );     
            binding.refresh();
        }
    ] as EditorListModel;

    def doOk() {
        if ( entity.amount <= 0 )
        throw new Exception("Please pay at least one item");

        entity.taxcredit = NumberUtil.round( entity.taxcredit ); 
        def amtwithtaxcredit = NumberUtil.round( entity.amount + entity.taxcredit ); 
        if ( amount != amtwithtaxcredit )  
        throw new Exception("Amount paid must be equal to total amount");

        if(!MsgBox.confirm('This transaction cannot be reversed. Please ensure the entries are correct. Proceed?')) return null;

        def m = [:];  
        m.objid = "BCP"+ new UID();
        m.refno = entity.refno; 
        m.refdate = entity.refdate;
        m.voided = 0;
        m.businessid = app.business.objid;
        m.applicationid = app.objid;
        m.appyear = app.appyear;
        m.reftype = "capture";
        m.amount = entity.amount;
        m.taxcredit = entity.taxcredit;
        m.items = entity.taxfees.findAll{ it.amtpaid > 0 }.collect {[   
                objid:'BCPITM'+new UID(),
                parentid: m.objid,
                account:it.account, 
                lob:it.lob,
                iyear:it.iyear,
                txntype: it.txntype,
                receivableid: it.receivableid, 
                amount:it.amtpaid,
                discount:it.discount, 
                sortorder: it.sortorder,
                surcharge:it.surchargepaid, 
                interest:it.interestpaid, 
                qtr: it.qtr,
                partial: (it.amtpaid==it.amtdue)?0:1
            ]}

        service.post( m );
        if ( handler ) handler(); 
        return "_close";
    }

    def doCancel() {
        return "_close";
    }

    void selectAll() {
        entity.taxfees.each {
            if(it.selected==false) {
                it.selected = true;
                it.amtpaid = it.amtdue;
                it.interestpaid  = NumberUtil.round( it.interest ? it.interest : 0.0 );
                it.surchargepaid = NumberUtil.round( it.surcharge ? it.surcharge : 0.0 );
                it.totalpaid = NumberUtil.round( it.amtpaid + it.surchargepaid + it.interestpaid ); 
            } 
        } 
        entity.amount = NumberUtil.round(entity.taxfees.sum{it.totalpaid}); 
        listModel.reload();
        allselected = true;
    }

    void unselectAll() {
        entity.taxfees.each {
            it.selected = false;
            it.amtpaid = 0;
            it.interestpaid = 0;
            it.surchargepaid = 0;
            it.totalpaid = 0;
        }
        entity.amount = 0; 
        listModel.reload();
        allselected = false;
    } 
    
    void calculate() { 
        if ( !entity.refdate ) throw new Exception('Ref.Date is required');
        if ( amount == null ) throw new Exception('Amount is required');
        if ( amount <= 0 ) throw new Exception('Amount must be greater than zero');
        
        def param = [:]; 
        param.payment = [ option: 'SPECIFY-AMOUNT', txnmode: 'CAPTURE', amount: amount ]; 
        loadBill( param ); 
    }
    void calculateQtr() {
        if ( !entity.refdate ) throw new Exception('Ref.Date is required');

        def str = MsgBox.prompt('Calculate up to Qtr :');
        if ( !str ) return;
        if ( !str.matches('[0-9]{1,1}')) {
            MsgBox.alert("Please enter a valid Qtr number");
            return; 
        }
        
        def qtr = str.toInteger();

        def param = [:]; 
        param.payment = [ option: 'FULLQTR', txnmode: 'CAPTURE', qtr: qtr ]; 
        loadBill( param ); 
    }
    void reset() {
        loadBill([:]); 
    }
}
