package com.rameses.gov.etracs.bpls.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.CrudLookupModel;

class BusinessApplicationLookupModel extends CrudLookupModel {

    def confs = [
        'name' : [ width: 100, maxWidth: 150 ],
        'tradename' : [ width: 150 ],  
        'appyear' : [ width: 80, maxWidth: 100, alignment: 'CENTER' ], 
        'appno' : [ width: 120 ], 
        'apptype' : [ width: 100, maxWidth: 120 ], 
        'dtfiled' : [ width: 100, maxWidth: 120, alignment: 'CENTER' ]
    ]; 
    
    public void initColumn( def c ) { 
        def conf = confs.get( c.name ); 
        if ( !conf ) return; 
        if ( conf.type != null ) c.type = conf.type;
        if ( conf.width != null ) c.width = conf.width; 
        if ( conf.maxWidth != null ) c.maxWidth = conf.maxWidth; 
        if ( conf.visible != null ) c.visible = conf.visible; 
        if ( conf.caption != null ) c.caption = conf.caption; 
        if ( conf.alignment != null ) c.alignment = conf.alignment; 
    } 
}   
