package com.rameses.gov.etracs.bpls.models;

import com.rameses.rcp.annotations.*
import com.rameses.rcp.common.*
import com.rameses.osiris2.client.*
import com.rameses.osiris2.common.*
import com.rameses.common.*;
import com.rameses.util.*;
import java.rmi.server.*;

class BusinessApplicationSectionAssessmentModel {

    @Binding
    def binding;

    @Caller
    def caller;

    def assessmentInfo;
    def appinfo;

    def appSvc;
    def paymentSvc;

    String title = "Assessment";
    def task;
    def entity;
    String entityName = "business_application:assessment";

    def menuInvokers = Inv.lookup('business_application:showeditmenu'); 

    public void load() {
        assessmentInfo = caller.assessmentInfo;
        appinfo = caller.appinfo;

        appSvc = caller.appService;
        paymentSvc = caller.paymentSvc;

        if (!caller.has_loaded_assessment) {
            assessmentInfo.load(); 
            caller.has_loaded_assessment = true;
        } 
        assessmentInfo.analyzer = false;
        assessmentInfo.refresh(); 
    } 

    void refresh() { 
        if ( caller ) { 
            caller.has_loaded_assessment = false; 
        } 
        load(); 
        binding.refresh(); 
        infoModel.reload(); 
        paymentModel.reload();
    } 
    
    def calculate() {
        // 
        // we will only allow this if there are no payments made 
        // 
        def payments = paymentModel.fetchList([:]); 
        if ( payments && payments.find{( it.voided==0 )} != null ) { 
            throw new Exception('There are payments already posted to the ledger. Please void them first');             
        } 
    
        assessmentInfo.handler = {
            assessmentInfo.verify(); 

            def m = [:];
            m.putAll(entity); 
            m.businessid = entity.business.objid; 
            appSvc.saveAssessment(m);
            assessmentInfo.load(); 
            assessmentInfo.analyzer = false; 
            assessmentInfo.refresh(); 
        } 
        assessmentInfo.calculate() ;
    }    

    boolean isAllowShowEditMenu() {         
        def appstate = entity.state.toString().toUpperCase(); 
        if ( !appstate.matches('INFO|ASSESSMENT')) return false; 
        if ( task?.state.toString() == 'assign-assessor' ) return false;
        
        boolean assessorUser = ( menuInvokers.find{( it.properties?.tag == 'assessor' )} != null );
        boolean infoUser = ( menuInvokers.find{( it.properties?.tag == 'info' )} != null );
                
        if (!caller?.prevmode?.contains('assessment') && task?.state.contains('assessment') && task?.owner==true) {
            return true; 
        } 
        if ( appstate == 'ASSESSMENT' && assessorUser == true && task?.owner == true ) {
            return true; 
        } 
        return ( appstate == 'INFO' && infoUser == true ); 
    } 

    def showEditMenu() { 
        // 
        // we will only allow this if there are no payments made 
        // 
        def payments = paymentModel.fetchList([:]); 
        if ( payments && payments.find{( it.voided==0 )} != null ) { 
            throw new Exception('There are payments already posted to the ledger. Please void them first');             
        } 

        def pop = new PopupMenuOpener();   
        if ( task?.state.toString() == 'assign-assessor' ) { 
            return pop; 
        } 
        
        def h = { t->
            if (t) refresh();
        }
        def list = Inv.lookupOpeners( "business_assessment:change", [entity:entity, handler:h] );
        list.each { pop.add( it ) }
        return pop;
    }

    def showPayMenu() {
        def h = { 
            refresh(); 
        } 
        def list = Inv.lookupOpeners( "business_assessment:payment", [entity:entity, handler:h] );
        def pop = new PopupMenuOpener();
        list.each { pop.add( it ); }
        return pop;
    }

    def selectedPayment; 
    def paymentModel = [
        fetchList: { o->
            return paymentSvc.getApplicationPayments([applicationid:entity.objid]);
        }, 
        onOpenItem: { o,col->
            String reftype = o.reftype.toString().toLowerCase();
            if ( reftype.matches('cashreceipt|eor')) {
                def op = Inv.lookupOpener( reftype +":open", [entity: [objid: o.refid]]);
                op.target = 'popup';
                return op;
            }  
        }
    ] as BasicListModel;
    
    def infoModel = [
        fetchList: { o->
            def tmps = []; 
            if ( entity.assessmentinfos ) tmps.addAll( entity.assessmentinfos ); 
            if ( entity.appinfos ) tmps.addAll( entity.appinfos );

            def results = [];                     
            def lobs = tmps.findAll{(it.lob?.objid != null)}.collect{ it.lob.objid }; 
            lobs.unique();                    
            lobs.each{ x-> 
                results.addAll(tmps.findAll{(it.lob?.objid == x)}); 
            } 
            results.addAll(tmps.findAll{(it.lob?.objid == null)}); 
            return results;
        }
    ] as BasicListModel;    

    void doAdvanceBill() {
        def h = { bd->
            assessmentInfo.runBill( bd );
            assessmentInfo.taxfeeModel.reload();
            paymentModel.reload();   
            binding.refresh();
        }
        Modal.show( "billdate:edit", [handler:h] )
    }

    def printAssessment() { 
        def h = { t-> 
            if (t) refresh(); 

            binding.refresh(); 
        }
        def list = Inv.lookupOpeners("business_application:assessment:print", [entity:entity, handler:h]);
        def pop = new PopupMenuOpener(); 
        pop.executeOnSingleResult = true; 
        list.each { pop.add( it ) }
        return pop;  
    } 

    def preview() {
        return Inv.lookupOpener("business:preassessment:printout", [entity: entity] ); 
    }

    def viewGrossInformation() { 
        return Inv.lookupOpener( "business_application_gross:open", [entity: entity.business] );
    }

    def viewInfoHistory() { 
        return Inv.lookupOpener( "business_application:info_history", [entity: entity.business] );
    }
}