package com.rameses.gov.etracs.bpls.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import java.rmi.server.*;
import com.rameses.gov.etracs.bpls.business.*;

class BusinessApplicationSectionHistoryModel {

    @Service("BusinessApplicationHistoryService")
    def service;

    @Service("BusinessApplicationService")
    def appSvc;

    @Caller 
    def caller;

    @Binding
    def binding;
    
    @Script("BusinessInfoUtil")
    def appinfo;

    String title = "Application History";
    def entityName = "business_application_history";
    def entity;
    def selectedItem;

    def listModel = [
        fetchList: { o->
            return service.getList([ businessid: entity.objid ]);
        } 
    ] as BasicListModel;


    def openItem() {
        if(!selectedItem) return;
        def type = selectedItem.filetype;
        def op = Inv.lookupOpener( type+":open", [entity: selectedItem] );
        binding.fireNavigation(op);
    } 

    void captureLateRenewal() { 
        def params = [ 
            apptype    : 'LATERENEWAL',  
            businessid : entity.objid                     
        ]; 
        def app = appSvc.initNew( params );

        if (!MsgBox.confirm("You are about to add a LateRenewal transaction for "+ app.appyear +". Proceed?")) return; 
                
        def success = false; 
        params = [ appSvc: appSvc, entity: app ]; 
        params.handler = { o-> 
            app.dtfiled = o.dtfiled; 
            success = true; 
        } 
        Modal.show('business_capture_late_renewal:create', params );
        if ( !success ) return; 

        appSvc.create( app ); 
        listModel.reload(); 
    } 

    def showReports() {
        if(selectedItem == null ) {
            throw new Exception("Please select an application");
        }
        def list = Inv.lookupOpeners( "business_application:reports", [entity:selectedItem, handler:[:]] );
        def pop = new PopupMenuOpener();
        list.each {
            pop.add( it );
        }
        return pop;
    }
} 
