package com.rameses.gov.etracs.bpls.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
        
class BusinessInfoHistoryListModel {
        
    @Service('BusinessInfoHistoryService') 
    def service; 

    @Binding
    def binding;

    @Caller
    def caller;
            
    def title = 'Information History';
    def entity = [:]; 
    def selecteditem;

    public void init() { 
    }

    def listHandler = [ 
        getColumns : {
            service.getColumns([ businessid: entity.objid ]);
        },
        fetchList: { 
            return service.getList([ businessid: entity.objid ]);
        } 
    ] as DataListModel 

    def doClose() {
        return "_close";
    }
}
