package com.rameses.gov.etracs.bpls.models;

import com.rameses.rcp.annotations.*
import com.rameses.rcp.common.*
import com.rameses.osiris2.client.*
import com.rameses.osiris2.common.*
import com.rameses.common.*;
import java.rmi.server.*
import com.rameses.util.*;
import com.rameses.gov.etracs.bpls.business.*;

class BusinessMasterModel {

    @Service("BusinessMasterService")
    def service;

    @FormId
    def formId
    
    @FormTitle
    def title
    
    @Binding
    def binding;
    
    def entityName = "businessform";
    def entity;
   
    def sections;
    def currentSection;
    def barcodeid;
    def startstep;
    
    def menuInvokers = Inv.lookup('business:showeditmenu'); 
    
    boolean _requires_data_approval;
    
    def openByBIN() {
        MsgBox.alert( 'open business by BIN '+barcodeid ); 
    }
    
    void open() {
        entity = service.open([ objid: entity.objid ]);
        title = entity.businessname + '(' + entity.bin + ')';
        loadSections();
        formId = entity.objid;
        
        _requires_data_approval = (entity._requires_data_approval.toString().matches('true|1'));
    }
    
    void reloadSection() {
        binding.refresh("subform");
    }
    
    void loadSections() {
        sections = InvokerUtil.lookupOpeners( "business:section", [entity: entity ] ).findAll {
            def vw = it.properties.visibleWhen;
            return  ((!vw)  ||  ExpressionResolver.getInstance().evalBoolean( vw, [entity:entity] ));
        }
        if( sections.size()>0 ) {
            currentSection = sections[0];
        }  
    }
    
    void reloadCurrentSection() {
        MsgBox.alert( currentSection.name );
    }
    
    boolean isAllowShowEditMenu() { 
        return ( menuInvokers ? true : false ); 
    } 

    def showEditMenu() {
        def h = { t-> 
            if (t) open(); 
            binding.refresh();
        } 
        def list = Inv.lookupOpeners( "business:change", [entity:entity, handler:h] );
        def pop = new PopupMenuOpener();
        list.each {
            pop.add( it );
        }
        return pop;
    }
    
    def showOwner() {
        if( !entity.owner?.objid )
            throw new Exception("No owner assigned");

        String stype = (entity.orgtype == 'SING') ?'entityindividual':'entityjuridical';
        return Inv.lookupOpener( stype + ":open", [entity: entity.owner] ); 
    }
    
    def createSMS() {
        def phoneno = entity.mobileno;
        if(!phoneno) phoneno = entity.owner?.mobileno;
        return Inv.lookupOpener('business_sms:create', [phoneno: phoneno]); 
    }
    
    void approveMigratedData() {
        boolean pass = MsgBox.confirm("You are about to approve the migrated data.\n Do you want to continue?");
        if ( !pass ) return; 
        
        service.approveMigratedData([ objid: entity.objid ]); 
        _requires_data_approval = false; 
    }
}
 