package com.rameses.gov.etracs.bpls.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.reports.*;
import java.text.SimpleDateFormat;
import java.rmi.server.UID;

class BusinessPermitReportModel extends ReportController {

    @Service( dynamic=true )
    def dynaSvc; 
    
    @Service("BusinessPermitService") 
    def permitSvc;
            
    def entity;
    def data = [:];
    def title = "Business Permit"

    String reportpath = "com/rameses/gov/etracs/bpls/reports/permit/"            
    String stdReportName = reportpath + "BusinessPermit.jasper";            
    String tmpReportName = reportpath + "BusinessPermit_Temporary.jasper";
                        
    @FormId
    def formId
            
    @FormTitle
    def formTitle
            
    def applicationid;
    def permittype;
            
    boolean isDynamic() {
        return true; 
    } 
            
    String getReportName() { 
        if ( permittype.toString().equalsIgnoreCase('TEMPORARY')) { 
            return tmpReportName; 
        } else {
            return stdReportName; 
        } 
    } 
                                                                                                                        
    def getReportData() { 
        data = permitSvc.getReport([ applicationid: applicationid ]); 
        if ( data.permittype ) permittype = data.permittype;                 
        if ( data.photo ) {
            try {
                data.photo = new java.io.ByteArrayInputStream( data.photo );
            } catch(e) {
                data.photo = null;
            } 
        }
        return data;
    }
            
    def printReport() {
        applicationid = entity.objid;
        permittype = entity.permit?.permittype;
        return preview(); 
    } 
            
    def openReport() {
        formId = entity.objid;
        formTitle = entity.permitno;
        permittype = entity.permittype;
        applicationid = entity.applicationid;
        preview(); 
    } 

    SubReport[] getSubReports(){ 
        return [
            new SubReport("BusinessPermitLOB", reportpath + "BusinessPermitLOB.jasper"),
            new SubReport("BusinessPermitOR", reportpath + "BusinessPermitPayment.jasper")
        ] as SubReport[]
    }
            
    void updatePlateno() {
        def p = MsgBox.prompt( 'Enter updated Plate No:' );
        if(!p) return;
                
        def permitid = entity.permit?.objid; 
        if ( !permitid ) permitid = entity.objid;
                
        permitSvc.updatePlateno([objid: permitid, plateno: p]);
        preview();
    }
            
    void updateRemarks() { 
        def permitid = entity.permit?.objid; 
        if ( !permitid ) permitid = entity.objid;            
                
        def h = { o->
            permitSvc.updateRemarks([ objid: permitid, remarks: o ]);
            preview();
        }
        Modal.show( "remarks:update", [handler: h, remarks: entity.remarks] );
    } 
            
    boolean isCanIssueOfficialPermit() {
        return permittype.toString().equalsIgnoreCase('TEMPORARY'); 
    } 
            
    void issueOfficialPermit() { 
        def m = [ applicationid: data.applicationid, businessid: data.businessid ];
        def resp = permitSvc.init( m ); 
        def prevplateno = resp?.prevplateno;

        boolean pass = false;                                   
        def h = { o->
            m.plateno = o.plateno;
            m.remarks = o.remarks;
            m.permitid = data?.objid; 
            resp = permitSvc.issueOfficialPermit( m ); 
            if ( resp?.permittype ) { 
                permittype = resp.permittype; 
                if ( entity.permit ) entity.permit.permittype = permittype; 
                if ( entity.permittype ) entity.permittype = permittype;
            } 
            pass = true; 
        }
        Modal.show( "businessplate:ask", [handler: h, entity: [plateno: prevplateno], allowTypeSelection: false]);
        if ( pass ) preview(); 
    } 
    
    void sendEmail() {
        if ( !data?.onlineapplication ) 
            throw new Exception("This feature is applicable for online transaction only");
            
        def contact = data.onlineapplication.contact; 
        if ( !contact?.email ) 
            throw new Exception("This feature requires a contact email");
            
        def bytes = null; 
        def out = new java.io.ByteArrayOutputStream(); 
        try {
            report.exportToPDF( out ); 
            bytes = out.toByteArray(); 
        } 
        finally {
            try { out.close(); }catch(Throwable t){;} 
        }
        
        def org = dynaSvc.lookup('OrgService').getRoot(); 
        def emailSvc = dynaSvc.lookup("JasperReportEmailService");
        def param = [ reportid: "business_permit", info: data, attachments: []];
        
        boolean pass = false;
        def h = { o->
            param.to = o.email;
            pass = true;
        }
        Modal.show("sys_specify_email", [ email: contact.email, handler: h ]);
        if ( !pass ) return; 

        param.attachments << [
            bytes: bytes, 
            title: "${org.objid}_${data.permitno}.pdf".toString()
        ];
        
        emailSvc.submit( param );
        MsgBox.alert("Message sent");
    }
}   