package com.rameses.gov.etracs.bpls.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
    
class BusinessReceivableModel {
    
    @Binding 
    def binding;
        
    @Service("BusinessReceivableService") 
    def service;
        
    def handler;
    def parent;
    def entity;
    def mode;

    @FormTitle
    def title;
        
    def txnTypes = [ "TAX", "REGFEE", "OTHERCHARGE" ];
        
    void create() {
        mode = 'create';
        entity = [amount:0.0, amtpaid:0.0];
        entity.iyear = parent.activeyear;
        entity.applicationid =  parent.applicationid;
        entity.businessid = parent.businessid;
    }

    void edit() {
        mode = 'edit';
    } 

    void delete() {
        service.removeReceivable( entity ); 
        if ( handler ) handler(); 
    } 

    void deleteItems() {
        if ( entity instanceof List ) {
            service.removeReceivable([ items: entity ]); 
            if ( handler ) handler(); 
        }
        else {
            throw new Exception("entity must be an instance of List");
        }
    } 

    def getAssessmentTypes() {
        if( parent.apptype == 'NEW' ) {
            return ['NEW'];
        } else {
            return ['NEW','RENEW'];
        }  
    }
        
    def getBalance() {
        return entity.amount - entity.amtpaid;
    }
                
    def doOk() {
        if ( mode == 'edit' ) {
            service.saveReceivable(entity);
        } else { 
            service.addReceivable(entity);
        } 
            
        if (handler) handler(); 
            
        return "_close";
    }
        
    def doCancel() {
        return "_close";
    }
}
