package com.rameses.gov.etracs.psa.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;

class PSICViewModel  {

    @Service("QueryService")
    def queryService;
    
    @Controller
    def controller;


    def title = 'Philippine Standard Industrial Classification (PSIC)';
    def searchText;

    
    void init() {
        
    }

    def formatNode( def o, def nodetype ) {
        def cap =  o.code + " - " + o.description ; 
        return  [id: o.code, caption:cap, item: o, type: nodetype, leaf:(nodetype=='subclass'?true:false)  ];
    }

    def  treeListModel = [
        isRootVisible: {
            return false;
        },
        isAllowOpenOnSingleClick: {
            return false; 
        },
        fetchItem: { node-> 
            /*    
            // update the data of the selected node 
            if ( !node?.item ) return null; 

            def m = [_schemaname: "market_orgunit"];
            m.where = ["objid = :objid ", [objid: node.item.id]]; 
            def list = queryService.getList( m ); 
            if ( !list ) return null; 

            def fo = list.first(); 
            return formatNode( fo );
            */ 
        },
        fetchList: { o->
            def nodetype = null;
            def m = [:];
            if( o.id == 'root' ) {
                nodetype = "section";
                m._schemaname = "psic_section";
                m.where = "1=1";
            }
            else {
                def v = o.item;
                if( v.type == "section") {
                    nodetype = "division";
                    m._schemaname = "psic_division";
                    m.where = ["sectionid = :id", [id: v.id ] ];
                }
                else if( v.type == "division") {
                    nodetype = "group";
                    m._schemaname = "psic_group";
                    m.where = ["divisionid = :id", [id: v.id ] ];
                }
                else if( v.type == "group") {
                    nodetype = "class";
                    m._schemaname = "psic_class";
                    m.where = ["groupid = :id", [id: v.id ] ];
                }
                else if( v.type == "class") {
                    nodetype = "subclass";
                    m._schemaname = "psic_subclass";
                    m.where = ["classid = :id", [id: v.id ] ];
                }  
                else {
                    return;
                }              
            }
            m.orderBy = "code";
            def nodes = [];
            queryService.getList(m).each {
                nodes << formatNode( it, nodetype );
            }
            return nodes;
        },
        /*    
        getContextMenu: { node->
            def menu = new PopupMenuOpener();
            menu.add( new PopupAction(name:"refreshNode", caption:"Refresh", obj: this ) );
            
            menu.add( new PopupAction(name:"addGroup", caption:"Add Group", parameters:node.item, obj:this ));
            if( node.item?.item?.parentid ) {
                menu.add( new PopupAction(name:"editNode", caption:"Edit", parameters:node.item, obj: this ) ); 
                menu.add( new PopupAction(name:"removeNode", caption:"Remove", parameters:node.item, obj: this ) );
            }                
            menu.add( new PopupAction(name:"showUnits", caption:"Show Units", parameters:node.item, obj: this ) );
            return menu;
        },
        */
    ] as TreeNodeModel;

    def listModel = [
        fetchList : {
            def m = [_schemaname : "psic_subclass"];
            m.where = ["(description LIKE :txt OR code LIKE :txt)", [txt: "%" + searchText+"%" ] ];
            return queryService.getList(m);
        }
    ] as BasicListModel;
    
    void doSearch() {
        listModel.reload();
    }
    
    def pageMode = "default";
    def viewList() {
        pageMode = "listview";
        return pageMode;    
    }
    
    def viewTree() {
        pageMode = "default";
        return pageMode;
    }
}