package com.rameses.admin.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;

class OrgLookupModel extends ServiceLookupController {

    @Service("OrgService")
    def orgSvc;

    def includes;
    def orgTypes;
    def orgclass;
    
    def parentOrg;
    def parentOrgs;

    void init() {
        def list = orgSvc.getOrgClasses();
        if ( includes ) { 
            includes = includes.replace(",", "|");
            list = list.findAll{ it.name.matches( includes ) }
        } 
        orgTypes = list; 
    }

    @PropertyChangeListener 
    def listener = [
        orgclass : { o-> 
            query.orgclass = o?.name; 
            super.reload(); 
        },
        parentOrg: { o-> 
            query.parent = o; 
            super.reload(); 
        }
    ];
    
    public void setOrgclass( def o ) { 
        def newparentOrgs = []; 
        if ( o.parentclass ) {
            newparentOrgs = orgSvc.getList([ orgclass: o.parentclass ]); 
        }
        
        this.orgclass = o; 
        this.parentOrg = null; 
        this.parentOrgs = newparentOrgs; 
    }
}