package com.rameses.treasury.common.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.reports.*;

class PaymentOrderFormReportModel extends ReportController {

    @Binding
    def binding;
    
    def reportHandler;
    def options;
    
    String title = "Order of Payment";
    
    def initReport() {
        options = [:];
        return preview();
    }
    
    String getReportName() {
        return reportHandler.getReportName(); 
    }
    
    SubReport[] getSubReports() { 
        return reportHandler.getSubReports(); 
    }
    
    Map getParameters() { 
        return reportHandler.getParameters();
    }
    
    def getReportData(){
        return reportHandler.getReportData( options ); 
    }
} 
