package com.rameses.gov.etracs.bpls.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;

class BplsOfficeFeeListModel  {

    @Service("PersistenceService")
    def service;

    @Service("QueryService")
    def queryService;

    @Invoker
    def invoker;
    
    final String SCHEMA_NAME = 'business_officefee'; 
    
    def entity;
    def list;
    def selectedItem;

    void init() {
    }

    String getTitle() { 
        return invoker.caption; 
    }
    
    def listModel = [
        fetchList: { o->
            def mm = [ _schemaname: SCHEMA_NAME ];
            mm.findBy = [ applicationid: entity.objid, role: invoker.role ]; 
            return queryService.getList( mm ); 
        },
        onOpenItem: { o, col->
            return updateFee();
        }
    ] as DataListModel;

    def addFee() {
        def h = { o->
            o._schemaname = SCHEMA_NAME; 
            o.applicationid = entity.objid; 
            o.role = invoker.role; 
            service.create( o );
            listModel.reload();
        }
        def mm = [ handler: h ];
        mm.domain = 'BPLS';
        mm.role = invoker.role;
        return Inv.lookupOpener("bpls_officefee:create", mm); 
    }

    def removeFee() {
        if ( !selectedItem ) {
            MsgBox.alert("Please select an item first");
            return;
        }
        
        if ( MsgBox.confirm("You are about to remove this item. Proceed?")) {
            def mm = [ _schemaname: SCHEMA_NAME ];
            mm.objid = selectedItem.objid;
            service.removeEntity( mm );
            listModel.reload();
        }
    }

    def updateFee() {
        if ( !selectedItem ) {
            MsgBox.alert("Please select an item first");
            return;
        }

        def mm = [ _schemaname: SCHEMA_NAME ];
        mm.objid = selectedItem.objid;
        mm = service.read( mm );

        def h = { o-> 
            o._schemaname = SCHEMA_NAME; 
            service.update( o ); 
            listModel.reload(); 
        }
        def op = Inv.lookupOpener("bpls_officefee:open", [ entity: mm, handler: h ]);
        op.target = "popup";
        return op;
    } 
} 
