package com.rameses.gov.etracs.bpls.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;

class BplsOfficeFeeModel {
    
    def mode;
    def entity;
    def handler
    
    def domain;
    def role;

    @PropertyChangeListener
    def listener = [
        "entity.txntype" : { o->
            entity.account = o.account;
            entity.txntypeid = o.objid;
        }
    ];

    void create() {
        mode = 'create'
        entity = [:];
    }

    void open() {
        mode = 'edit'
    }

    def doOk() {
        if( handler) handler(entity);
        return "_close";
    }

    def doCancel() {
        return "_close";
    }
    
    def getLookupHandler() {
        def param = [:];
        param.put('query.domain', domain); 
        param.put('query.role', role); 
        return Inv.lookupOpener("business_billitem_txntype:lookup", param);
    }
}
        