package com.rameses.filemgmt.components;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;

class FileItemViewPanelModel extends ComponentBean {

    @Binding
    def binding;
    
    @Service( dynamic = true ) 
    def dynaSvc; 
    
    Map cacheImageMap; 
    FileItemViewModel fileItemViewModel;
    FileItemViewPanel fileItemViewPanel; 
    
    def fileManager = com.rameses.filemgmt.FileManager.instance;
    def downloadManager = com.rameses.filemgmt.FileDownloadManager.instance; 
    
    def loadingStatusMessage;
    boolean cancelled;
    
    void setInit( boolean b ) {

    }
    
    def getCardName() {
        if ( cacheImageMap == null ) {
            cacheImageMap = [:]; 
        }

        def output = "loading";
        def objid = fileItemViewModel?.objid;
        if ( !objid ) return output;
        
        def image = cacheImageMap.get( objid );
        if ( image ) return "view"; 
        
        if ( fileItemViewPanel ) {
            fileItemViewPanel.addLoadTask( objid );
        }
        return "loading"; 
    }

    void setLoadTask( objid ) {
        loadImage( objid ); 
    }
    
    void loadImage( objid ) { 
        def fileitem = getFileItem( objid, fileItemViewModel.connection ); 
        if ( !fileitem ) return; 

        def fileloc = fileitem.fileloc; 
        if ( fileloc.type == 'file' ) {
            loadImageFromFile( fileitem ); 
        }
        else {
            def downloadItem = null; 
            def filehandler = [
                onTransfer: { fileid, filesize, bytesprocessed-> 
                    if ( cancelled ) return; 

                    Number num = ((bytesprocessed / filesize) * 100); 
                    loadingStatusMessage = 'Downloading please wait... ('+ num.intValue() +'%)';
                    binding.notifyDepends('loadingStatusMessage'); 
                }, 
                onCompleted: {
                    if ( cancelled ) return;
                    
                    if ( cacheImageMap == null ) {
                        cacheImageMap = [:]; 
                    } 
                    cacheImageMap.put( fileitem.objid, downloadItem.content ); 

                    loadingStatusMessage = null;
                    binding.notifyDepends('images'); 
                    binding.notifyDepends('fileitem'); 
                }
            ] as com.rameses.filemgmt.DefaultFileDownloadHandler;
            
            downloadItem = downloadManager.doBasicdownload( fileitem.objid, fileitem.filetype, fileitem.filesize, fileloc, filehandler, fileitem.connection ); 
        }
    }
    
    void loadImageFromFile( fileitem ) {
        def conf = fileitem.fileloc; 
        def url = new URL( conf.url ); 
        def dir = new java.io.File( url.toURI()); 
        if ( conf.rootdir ) { 
            dir = new java.io.File( dir, conf.rootdir ); 
        }

        def fname = fileitem.objid.toString() +'.'+ fileitem.filetype; 
        def file = new File( dir, fname ); 
        def imageURL = file.toURI().toURL();
        
        if ( cacheImageMap == null ) {
            cacheImageMap = [:]; 
        } 
        
        cacheImageMap.put( fileitem.objid, new javax.swing.ImageIcon( imageURL )); 
        
        loadingStatusMessage = null;
        binding.notifyDepends('images'); 
        binding.notifyDepends('fileitem'); 
    }
    
    def getImage() {
        def objid = fileItemViewModel?.objid;
        return ( cacheImageMap ? cacheImageMap.get( objid.toString()) : null );
    }
    
    def getFileItem( objid, connection ) {
        def svc = dynaSvc.lookup( 'PersistenceService', connection ); 
        def item = svc.read([_schemaname: 'sys_fileitem', objid: objid]); 
        if ( !item ) return null; 
        
        item.connection = connection; 
        
        def head = svc.read([_schemaname: 'sys_file', objid: item.parentid ]); 
        if ( head ) {
            item.filetype = head.filetype; 
        }
        
        def filelocid = item.filelocid;
        
        def appEnv = ClientContext.getCurrentContext().getAppEnv(); 
        def keyName = [ connection, "filemgmt.connection" ].findAll{ it }.join("."); 
        def connFileName = appEnv.get( keyName );
        if( connFileName != null && connFileName.trim().length() > 0 ) {
            filelocid = connFileName; 
        }
        
        def fileloc = fileManager.getLocation( item.connection, filelocid ); 
        if ( !fileloc ) {
            println "[WARN] '"+ filelocid +"' file location config not found";
            return null; 
        }
        
        item.fileloc = fileloc; 
        return item; 
    }
}
